<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%preset_content}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%layout}}`
 */
class M210414103112AddPresetIdColumnToPresetContentTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%preset_content}}', 'preset_id', $this->integer()->null());

        // creates index for column `preset_id`
        $this->createIndex(
            '{{%idx-preset_content-preset_id}}',
            '{{%preset_content}}',
            'preset_id'
        );

        // add foreign key for table `{{%layout}}`
        $this->addForeignKey(
            '{{%fk-preset_content-preset_id}}',
            '{{%preset_content}}',
            'preset_id',
            '{{%layout}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%layout}}`
        $this->dropForeignKey(
            '{{%fk-preset_content-preset_id}}',
            '{{%preset_content}}'
        );

        // drops index for column `preset_id`
        $this->dropIndex(
            '{{%idx-preset_content-preset_id}}',
            '{{%preset_content}}'
        );

        $this->dropColumn('{{%preset_content}}', 'preset_id');
    }
}
