<?php

namespace bitcream\smartsignage\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%preset_content}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%preset}}`
 */
class M210420083333AddPresetIdColumnToPresetContentTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%preset_content}}', 'preset_id', $this->integer()->null());

        // creates index for column `preset_id`
        $this->createIndex(
            '{{%idx-preset_content-preset_id}}',
            '{{%preset_content}}',
            'preset_id'
        );

        // add foreign key for table `{{%preset}}`
        $this->addForeignKey(
            '{{%fk-preset_content-preset_id}}',
            '{{%preset_content}}',
            'preset_id',
            '{{%preset}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%preset}}`
        $this->dropForeignKey(
            '{{%fk-preset_content-preset_id}}',
            '{{%preset_content}}'
        );

        // drops index for column `preset_id`
        $this->dropIndex(
            '{{%idx-preset_content-preset_id}}',
            '{{%preset_content}}'
        );

        $this->dropColumn('{{%preset_content}}', 'preset_id');
    }
}
