<?php

$taxonomies = [
	'highlights'    			=> __('In Evidenza','thor'),
	'development' 				=> __('Sviluppo','thor'),
	'maximum_print_height' 		=> __('Massima Altezza di stampa','thor'),
	'number_of_cylinders' 		=> __('Numero di Cilindri','thor'),
	'metallic_effect' 			=> __('Effetto Metallico','thor'),
	'touch_effect'				=> __('Touch Effect','thor'),
	'features'					=> __('Caratteristiche','thor'),
	'intended_use'				=> __('Destinazione d\'uso','thor'),
];

foreach($taxonomies as $key => $taxonomy) {
	add_action('init', function () use ($key, $taxonomy) {
		$labels = array(
			'name'                       => _x($taxonomy , 'Taxonomy General Name', 'thor'),
			'singular_name'              => _x($taxonomy , 'Taxonomy Singular Name', 'thor'),
			'menu_name'                  => __($taxonomy , 'thor'),
		);
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => false,
			'public'                     => true,
			'show_ui'                    => false,
			'publicly_queryable'	 	 => false,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'show_in_rest'               => true,
		);
		register_taxonomy($key, array('decor'), $args);
	}, 0);
};


add_action('init', function () {
	$labels = array(
		'name'                       => _x('Categorie decori', 'Taxonomy General Name', 'thor'),
		'singular_name'              => _x('Categorie decori', 'Taxonomy Singular Name', 'thor'),
		'menu_name'                  => __('Categorie decori', 'thor'),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'publicly_queryable'	 	 => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
	);
	register_taxonomy('decors-category', array('decor'), $args);
}, 0);
