<?php

/**
* Disable ACF UI in non-development environment
*/
defined('ACF_LITE') || define('ACF_LITE', defined('WP_ENV') && WP_ENV !== 'development');

add_action('acf/render_field_settings',function ($field) {
  acf_render_field_setting($field, array(
    'label'      => __('Solo lettura?', 'acf'),
    'instructions'  => '',
    'type'      => 'radio',
    'name'      => 'readonly',
    'choices'    => array(
      0        => __("No", 'acf'),
      1        => __("Yes", 'acf'),
    ),
    'layout'  =>  'horizontal',
  ));
});

/**
 * Google maps api key
 */
add_filter('acf/settings/google_api_key', function () {
  return 'AIzaSyBsuj8bQz3GjKRjMPuO8S3svzkI5uM3lo8';
});

/**
 * Place ACF JSON in field-groups directory
 */
add_filter('acf/settings/save_json', function ($path) {
  $path = plugin_dir_path( __FILE__ ) . '/field-groups';

  return $path;
}, 10);

add_filter('acf/settings/load_json', function ($paths) {
  unset($paths[0]);
  $paths[] = plugin_dir_path( __FILE__ ) . '/field-groups';
  return $paths;
}, 10, 1);


// ---------------
// ADMIN PAGES
// ------------------------------------------------------

add_action( 'init', function () {
  if (
    !(function_exists('acf_add_options_page')
      && function_exists('acf_add_options_sub_page')
    )
  ) return false;
  
  $general_conf = acf_add_options_page(array(
    'page_title' 	=> 'Configurazioni generali',
    'menu_title' 	=> 'Configurazioni',
    'menu_slug' 	=> 'theme-general-conf',
    'capability' 	=> 'edit_others_pages',
    'redirect'    => true,
    'icon_url'    => 'dashicons-welcome-view-site'
  ));

  acf_add_options_page(array(
    'page_title' 	=> 'Configurazione Popup',
    'menu_title' 	=> 'Configurazione Popup',
    'menu_slug' 	=> 'popup-config',
    'capability' 	=> 'edit_others_pages',
    'redirect'    => true,
    'icon_url'    => 'dashicons-editor-expand'
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Opzioni generali',
    'menu_title' 	=> 'Generali',
    'parent_slug' 	=> $general_conf['menu_slug'],
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Archivio articoli',
    'menu_title' 	=> 'Archivio articoli',
    'parent_slug' 	=> 'edit.php',
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Archivio inspiration',
    'menu_title' 	=> 'Archivio inspiration',
    'parent_slug' 	=> 'edit.php?post_type=inspiration',
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Pannelli Menu',
    'menu_title' 	=> 'Pannelli Menu',
    'parent_slug' 	=> 'themes.php',
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Archivio decori',
    'menu_title' 	=> 'Archivio decori',
    'parent_slug' 	=> 'edit.php?post_type=decor',
  ));

  acf_add_options_sub_page(array(
    'page_title' 	=> 'Opzioni avanzate',
    'capability'  => 'activate_plugins',
    'menu_title' 	=> 'Avanzate',
    'parent_slug' 	=> $general_conf['menu_slug'],
  ));

  // $social_page = acf_add_options_page(array(
  //   'page_title' 	=> 'Account social',
  //   'menu_title' 	=> 'Social',
  //   'menu_slug' 	=> 'theme-social-account',
  //   'capability' 	=> 'edit_others_pages',
  //   'redirect'    => true,
  //   'icon_url'    => 'dashicons-share'
  // ));
});
    