<?php
function product_collection() {

	$labels = array(
		'name'                       => _x( 'Product collections', 'Taxonomy General Name', 'thor' ),
		'singular_name'              => _x( 'Product collection', 'Taxonomy Singular Name', 'thor' ),
		'menu_name'                  => __( 'Product collections', 'thor' ),
		'all_items'                  => __( 'All Items', 'thor' ),
		'parent_item'                => __( 'Parent Item', 'thor' ),
		'parent_item_colon'          => __( 'Parent Item:', 'thor' ),
		'new_item_name'              => __( 'New Item Name', 'thor' ),
		'add_new_item'               => __( 'Add New Item', 'thor' ),
		'edit_item'                  => __( 'Edit Item', 'thor' ),
		'update_item'                => __( 'Update Item', 'thor' ),
		'view_item'                  => __( 'View Item', 'thor' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'thor' ),
		'add_or_remove_items'        => __( 'Add or remove items', 'thor' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'thor' ),
		'popular_items'              => __( 'Popular Items', 'thor' ),
		'search_items'               => __( 'Search Items', 'thor' ),
		'not_found'                  => __( 'Not Found', 'thor' ),
		'no_terms'                   => __( 'No items', 'thor' ),
		'items_list'                 => __( 'Items list', 'thor' ),
		'items_list_navigation'      => __( 'Items list navigation', 'thor' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => false,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
	);
	register_taxonomy( 'product-collection', array( 'product', 'tint', 'finiture', 'property' ), $args );

}
add_action( 'init', 'product_collection', 0 );