<?php

$taxonomies = [
	'highlights'    			=> __('Highlights','thor'),
	'development' 				=> __('Development','thor'),
	'maximum_print_height' 		=> __('Maximum Print Height','thor'),
	'number_of_cylinders' 		=> __('Number of Cylinders','thor'),
	'metallic_effect' 			=> __('Metallic Effect','thor'),
	'touch_effect'				=> __('Touch Effect','thor'),
	'features'					=> __('Features','thor'),
	'intended_use'				=> __('Intended use','thor'),
];

foreach($taxonomies as $key => $taxonomy) {
	add_action('init', function () use ($key, $taxonomy) {
		$labels = array(
			'name'                       => _x($taxonomy , 'Taxonomy General Name', 'thor'),
			'singular_name'              => _x($taxonomy , 'Taxonomy Singular Name', 'thor'),
			'menu_name'                  => __($taxonomy , 'thor'),
		);
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => false,
			'public'                     => true,
			'show_ui'                    => false,
			'publicly_queryable'	 	 => false,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'show_in_rest'               => true,
		);
		register_taxonomy($key, array('decor'), $args);
	}, 0);
};

add_action('init', function () {
	$labels = array(
		'name'                       => __('Intended use', 'thor'),
		'singular_name'              => __('Intended use', 'thor'),
		'menu_name'                  => __('Intended use', 'thor'),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => false,
		'public'                     => true,
		'show_ui'                    => true,
		'publicly_queryable'	 	 => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
	);
	register_taxonomy('intended_use', array('decor'), $args);
}, 0);


add_action('init', function () {
	$labels = array(
		'name'                       => _x('Decor categories', 'Taxonomy General Name', 'thor'),
		'singular_name'              => _x('Decor categories', 'Taxonomy Singular Name', 'thor'),
		'menu_name'                  => __('Decor categories', 'thor'),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'publicly_queryable'	 	 => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
	);
	register_taxonomy('decors-category', array('decor'), $args);
}, 0);
