<?php
/**
 * The template for displaying Service archive.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>
<header class="page-header">
  <div class="container">

    <?php dueper_breadcrumbs(); ?>
    <h1 class="page-title">
        <?php
          if ( is_category() ) :
              single_cat_title();

          elseif ( is_post_type_archive() ) :
              post_type_archive_title();

          elseif ( is_tag() ) :
              single_tag_title();

          elseif ( is_author() ) :
              /* Queue the first post, that way we know
               * what author we're dealing with (if that is the case).
              */
              the_post();
              printf( __( 'Author: %s', 'dueper' ), '<span class="vcard">' . get_the_author() . '</span>' );
              /* Since we called the_post() above, we need to
               * rewind the loop back to the beginning that way
               * we can run the loop properly, in full.
               */
              rewind_posts();

          elseif ( is_day() ) :
              printf( __( 'Day: %s', 'dueper' ), '<span>' . get_the_date() . '</span>' );

          elseif ( is_month() ) :
              printf( __( 'Month: %s', 'dueper' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

          elseif ( is_year() ) :
              printf( __( 'Year: %s', 'dueper' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

          elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
              _e( 'Asides', 'dueper' );

          elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
              _e( 'Images', 'dueper');

          elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
              _e( 'Videos', 'dueper' );

          elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
              _e( 'Quotes', 'dueper' );

          elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
              _e( 'Links', 'dueper' );

          else :
              _e( 'Archives', 'dueper' );

          endif;
      ?>
      </h1>
    </div><!--container-->
</header><!-- .page-header -->


<div class="container page-content">
  <div class="row">
    <main class="col-md-10 col-md-offset-1">
      <?php if ( have_posts() ) :
        while ( have_posts() ) : the_post();
        echo '<div class="col-md-4 col-md-offset-0 col-sm-6 col-sm-offset-0 col-xs-10 col-xs-offset-1">';
          get_template_part('partials/teaser/_teaser','service'); ?>
      </div>
        <?php endwhile;
      endif;
      wp_reset_query();?>
      <div class="clearfix"></div>
      <hr />
      <?php if(function_exists('wp_pagenavi')):
        wp_pagenavi();
      endif;?>
    </main><!--col-md-8-->
    <!-- <aside class="col-md-4 col-md-pull-8"> -->
      <?php //get_template_part('partials/_list-categories');?>
    <!-- </aside><!--col-md-4-->
  </div><!--row-->
</div><!--container-->
<?php get_footer(); ?>
