'use strict';
var config = require('../config');
var notifyError = require('../lib/notifyError');

var gulp = require('gulp');
var notify = require('gulp-notify');
var plumber = require('gulp-plumber');
var size = require('gulp-size');
var sass = require('gulp-sass');
var scss = require("postcss-scss");
var rename = require('gulp-rename');
var postcss = require('gulp-postcss');
var sourcemaps = require('gulp-sourcemaps');
var browserSync = require('browser-sync');
var concat = require('gulp-concat');

// PostCSS plugins
var autoprefixer = require('autoprefixer');
var reporter = require('postcss-reporter');
var cssnano = require('cssnano');

gulp.task('styles', function() {

    var plugins = [
        autoprefixer(config.postcssPlugins.autoprefixer.browsers),
        cssnano({safe: true, discardComments: {removeAll: true}})
    ];
    //Compilo, comprimo i css/sass custom
    gulp.src(config.src.scss)
        .pipe(plumber({errorHandler: notifyError}))
        .pipe(sourcemaps.init())
        .pipe(sass())
        .pipe(postcss(plugins))
        .pipe(rename(config.opts.renamemin))
        .pipe(size(config.tasks.size.opts))
        .pipe(sourcemaps.write('./maps'))
        .pipe(gulp.dest(config.dest.css))
        .pipe(browserSync.stream())

    //Comprimo i css/sass vendor
    gulp.src(config.src.css)
      .pipe(concat('vendor.css'))
      .pipe(rename(config.opts.renamemin))
      .pipe(postcss(plugins))
      .pipe(gulp.dest(config.dest.css))
});
