<?php
/**
 * Template Name: Blog
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>
<header class="page-header">
  <div class="container">
    <?php dueper_breadcrumbs(); ?>
    <h1 class="page-title"><?php the_title(); ?></h1>
  </div><!--container-->
</header><!-- .page-header -->
<div class="container page-content">
  <div class="row">
    <div class="col-md-8 col-md-push-4">

      <?php
      $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
      $blog_args = array(
        'post_type'=>'post',
        'paged' => $paged
      );
      $blog_posts = new WP_Query($blog_args);
      if ($blog_posts->have_posts()) :
        while($blog_posts->have_posts()) : $blog_posts->the_post();
        echo '<div class="col-md-6">';
          the_post_teaser();
        echo '</div>';
        endwhile;
      endif;
      wp_reset_query();?>
      <div class="clearfix"></div>
      <hr />
      <?php if(function_exists('wp_pagenavi')):
        wp_pagenavi(array('query'=>$blog_posts));
      endif;?>
    </div><!--col-md-8-->
    <div class="col-md-4 col-md-pull-8">
      <?php get_template_part('partials/_list-categories');?>
    </div><!--col-md-4-->
  </div><!--row-->
</div><!--container-->
<?php get_footer(); ?>
