<?php
/**
 * Template Name: Contatti
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header();

while ( have_posts() ) : the_post(); ?>

<?php
	$subtitle = get_field('sottotitolo');
	$punto_title = get_field('punto_title');
	$punto_text = get_field('punto_text');
	$phone = get_field('phone');
	$mail= get_field('mail');
	$time = get_field('time');
	$richiedi_title = get_field('richiedi_title');
	$richiedi_text = get_field('richiedi_text');
	$contact_form = get_field('contact_form');
	$where_title = get_field('where_title');
	$where_text = get_field('where_text');

	$address = get_field('address','option');
?>

<div class="container">
	<header class="page-header">
		<?php dueper_breadcrumbs(); ?>
		<h1 class="page-title"><?php the_title(); ?></h1>
		<?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
	</header>
</div>
	<div class="container page-content">
		<div class="row">
			<div class="col-md-6">
				<?php if($punto_title) echo '<h3 class="section-title">'.$punto_title.'</h3>'; ?>
				<?php if($punto_text) echo '<div class="section-content">'.$punto_text.'</div>'; ?>
				<div class="info-list">
					<?php if($phone) echo '<span class="info big"><i class="icon-phone"></i>'.$phone.'</span>'; ?>
					<?php if($time) echo '<span class="info"><i class="icon-clock"></i>'.$time.'</span>'; ?>
					<?php if($address) echo '<span class="info"><i class="icon-pin"></i>'.$address.'</span>'; ?>
					<?php if($mail) echo '<span class="info"><i class="icon-mail"></i><a href="mailto:'.$mail.'">'.$mail.'</a></span>'; ?>
				</div>
			</div>
			<div class="col-md-6">
				<?php if($richiedi_title) echo '<h3 class="section-title">'.$richiedi_title.'</h3>'; ?>
				<?php if($richiedi_text) echo '<div class="section-content">'.$richiedi_text.'</div>'; ?>
				<?php  echo do_shortcode('[gravityform id="' . $contact_form['id'] . '" title="false" description="false" ajax="true"]');?>
			</div>
			<div class="col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1">
				<?php if($where_title) echo '<h3 class="section-title">'.$where_title.'</h3>'; ?>
				<?php if($where_text) echo '<div class="section-content">'.$where_text.'</div>'; ?>
			</div>
		</div><!--row-->
	</div><!--container-->
	<?php get_template_part('includes/maps/_maps'); ?>
	<?php get_template_part('partials/_offices'); ?>
	
<?php endwhile;
get_footer(); ?>
