<?php

/*
| -------------------------------------------------------------------
| Aggiungo style bottone
| -------------------------------------------------------------------
|
| */
function wpb_mce_buttons_2($buttons) {
    array_unshift($buttons, 'styleselect');
    return $buttons;
}
add_filter('mce_buttons_2', 'wpb_mce_buttons_2');

/*
* Callback function to filter the MCE settings
*/

function my_mce_before_init_insert_formats( $init_array ) {  
// Definisco lo style_formats in un array
	$style_formats = array(  
		// Each array child is a format with it's own settings
		array(  
			'title' => 'Image full width',  
			'block' => 'div',  
			'classes' => 'full-width',
			'wrapper' => true,
		),
        array(  
			'title' => 'Image Boxed',  
			'block' => 'div',  
			'classes' => 'boxed',
			'wrapper' => true,
		),
        array(  
			'title' => 'Image Vertical',  
			'block' => 'div',  
			'classes' => 'vertical',
			'wrapper' => true,
		)
	);  
	// Insert the array, JSON ENCODED, into 'style_formats'
	$init_array['style_formats'] = json_encode( $style_formats );  
	return $init_array;  
} 
// Attach callback to 'tiny_mce_before_init' 
add_filter( 'tiny_mce_before_init', 'my_mce_before_init_insert_formats' ); 


/* Carico css lato backend*/
function add_admin_css() {
    add_editor_style( get_template_directory_uri().'/functions/editor-custom-style/css/custom-editor-style.css');
}
add_action( 'admin_init', 'add_admin_css' );

?>