<?php

//Add wp_pagenavi bootstrap compatibility
if ( !function_exists('wp_pagenavi_bootstrap')) {
  add_filter( 'wp_pagenavi', 'wp_pagenavi_bootstrap', 10, 2 );
  function wp_pagenavi_bootstrap($html) {
    $out = '';
    //wrap a's and span's in li's
    $out = str_replace("<div","",$html);
    $out = str_replace("class='wp-pagenavi' role='navigation'>","",$out);
    $out = str_replace("<a","<li><a",$out);
    $out = str_replace("</a>","</a></li>",$out);
    $out = str_replace("<span","<li><span",$out);
    $out = str_replace("</span>","</span></li>",$out);
    $out = str_replace("</div>","",$out);
      $out = str_replace("<li><span class='current'>","<li class='active'><span>",$out);

    return '<div class="text-center"><ul class="pagination pagination-centered">'.$out.'</ul></div>';
  }
  
}
// Remove additional profile info
if (!function_exists('dueper_remove_profile_fields')) {
  add_filter('user_contactmethods','dueper_remove_profile_fields', 10, 2);
  function dueper_remove_profile_fields( $contactmethods ) {
    unset($contactmethods['aim']);
    unset($contactmethods['jabber']);
    unset($contactmethods['yim']);
    return $contactmethods;
  }
}

// Add featured image in RSS
if ( !function_exists('dueper_rss_post_thumbnail')) {
  add_filter('the_excerpt_rss', 'dueper_rss_post_thumbnail', 10, 2);
  add_filter('the_content_feed', 'dueper_rss_post_thumbnail', 10, 2);
  function dueper_rss_post_thumbnail($content) {
    global $post;
    if(has_post_thumbnail($post->ID)) :
      $content = '<p>' . get_the_post_thumbnail($post->ID) .
      '</p>' . get_the_content();
    endif;
    return $content;
  }
}

// Revising Default Excerpt
if ( !function_exists('bootstrapwp_excerpt')) {
  add_filter('excerpt_more', 'bootstrapwp_excerpt', 10, 2);
  function bootstrapwp_excerpt($more) {
    global $post;
    return '...';
  }
}

//Revising Default Excerpt
if ( !function_exists('dueper_excerpt_length')) {
  add_filter( 'excerpt_length', 'dueper_excerpt_length', 10, 2 );
  function dueper_excerpt_length( $length ) {
    return 20;
  }
}

// Localize admin-ajax
if ( !function_exists('frontend_enqueued_scripts')) {
function frontend_enqueued_scripts() {
    wp_localize_script( 'custom', 'ajax_posts', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'noposts' => __('No older posts found', 'Dueper'),
    ));
  }
  add_action( 'wp_enqueue_scripts', 'frontend_enqueued_scripts' );
}
