<?php
/**
 * Template Name: Gare Attive
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header();

while ( have_posts() ) : the_post(); ?>

<?php
  $gare_args = array(
    'post_type'=>'gara',
    'posts_per_page'  => -1
  );
  $gare_posts = new WP_Query($gare_args);
  $subtitle = get_field('sottotitolo');

  $terms = get_the_terms( get_the_ID(), 'on-draught' );
  $parent_terms = get_terms(array(
    'taxonomy' => 'gara_category',
    'parent' => 0, // Imposta il valore su 0 per ottenere solo i termini genitori
    'hide_empty' => false, // Mostra anche i termini vuoti
  ));
  // var_dump($parent_terms);
?>

  <div class="container">
    <header class="page-header">
      <?php dueper_breadcrumbs(); ?>
      <h1 class="page-title"><?php the_title(); ?></h1>
      <?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
    </header>
  </div>

  <?php get_template_part('includes/_slider', 'internal'); ?>
  <div class="container page-content">
    <div class="row">
      <main class="col-md-8 col-md-push-4">
        <?php foreach($parent_terms as $term) : ?>
        <?php echo '<h6 class="small-pre"><a href="'.get_term_link($term->term_id, $term->taxonomy).'">'.$term->name.'</a></h6>';?>
        <?php endforeach; ?>
        <?php wp_reset_query();?>
      </main>
      <aside class="col-md-4 col-md-pull-8">
        <?php get_template_part('partials/_list-gare'); ?>
      </aside>
    </div><!--row-->
  </div><!--container-->
  <?php
    $my_wp_query = new WP_Query();
    $all_wp_pages = $my_wp_query->query(array('post_type' => 'page', 'posts_per_page' => '-1'));
    $children = get_page_children( get_the_ID(), $all_wp_pages );
    if($children) : ?>
      <div class="container page-children">
        <div class="row">
        <?php foreach($children as $child) : ?>
          <div class="col-md-6 child-page">
            <?php echo '<h6 class="small-pre">'.get_the_title($child->ID).'</h6>';?>
            <div class="link-wrapper">
              <a href="<?php echo get_permalink($child->ID);?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>

<?php endwhile; ?>

<?php get_footer(); ?>
