<?php
/**
 * Template Name: Video archive
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header();
if ( have_posts() ) : the_post(); ?>

  <header class="page-header">
    <div class="container">
      <h1 class="page-title"><?php the_title(); ?></h1>
    </div><!--container-->
  </header><!-- .page-header -->
  <div class="container page-content">
    <?php dueper_breadcrumbs(); ?>

    <?php if(get_field('active_video','option')): ?>
      <div class="row">
        <div class="col-md-12">
          <?php
          $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
          $blog_args = array(
            'post_type'=>'videopost',
            'paged' => $paged
          );
          $blog_posts = new WP_Query($blog_args);
          if ($blog_posts->have_posts()) :
            echo '<div class="row video-page-loop">';
              while($blog_posts->have_posts()) : $blog_posts->the_post();
                echo '<div class="col-md-4 col-sm-6">';
                  get_template_part('partials/video/_video-teaser-standard');
                echo '</div>';
              endwhile;
            echo '</div>';
          endif;
          wp_reset_query();?>

          <?php if(function_exists('wp_pagenavi')):
            wp_pagenavi(array('query'=>$blog_posts));
          endif;?>
        </div><!--col-md-12-->
      </div><!--row-->
    <?php else: ?>
      <span class="lead"><?php _e('Videos are currently disabled, enable them in admin area','dueper'); ?></span>
    <?php endif; ?>
  </div><!--container-->

<?php endif;
get_footer(); ?>
