<?php
/**
 * The template for displaying Category pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>
<header class="page-header">
  <div class="container">
    <?php dueper_breadcrumbs(); ?>
    <h1 class="page-title"><?php single_cat_title(); ?></h1>
  </div><!--container-->
</header><!-- .page-header -->
<div class="container">
  <?php
  $term = get_queried_object();
  $term_id = $term->term_id;
  $taxonomy_name = $term->taxonomy;
  $children = get_terms( array(
      'taxonomy' => $taxonomy_name,
      'parent' => get_queried_object_id(),
    ) );
    if( ! is_wp_error($children)) : ?>
      <div class="container page-children">
        <div class="row">
        <?php foreach($children as $child) : ?>
          <?php //$child_term = get_term_by( 'id', $child, $taxonomy_name ); ?>
          <div class="col-md-6 child-page">
            <?php echo '<h6 class="small-pre">'.$child->name.'</h6>';?>
            <div class="link-wrapper">
              <a href="<?php echo get_term_link( $child, $taxonomy_name );?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
        <hr />
      </div>
    <?php endif; ?>
    <?php wp_reset_query();?>
</div>
<div class="container page-content">
  <div class="row">
    <main class="col-md-10 col-md-offset-1">
      <?php if ( have_posts() ) :
        while ( have_posts() ) : the_post();
        echo '<div class="col-md-4 teaser-standard">'; ?>
        <h6 class="small-pre"><?php the_title();?></h6>
        <div class="link-wrapper">
          <a href="<?php echo get_permalink();?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
        </div>
        <?php echo '</div>';
        endwhile;
      endif;
      wp_reset_query();?>
      <div class="clearfix"></div>
      <?php if(function_exists('wp_pagenavi')):
        wp_pagenavi();
      endif;?>
    </main><!--col-md-8-->
    <!-- <aside class="col-md-4 col-md-pull-8">
      <?php //get_template_part('partials/_list-categories');?>
    </aside> -->
  </div><!--row-->
</div><!--container-->
<?php get_footer(); ?>
