<?php
  $title_concorso = get_field('concorso_title');
  $title_gara = get_field('gara_title');
  $link_concorsi = get_field('concorsi_link');
  $pre_link_concorsi = get_field('concorsi_pre_link');
  $link_gare = get_field('gare_link');
  $pre_link_gare = get_field('gare_pre_link');
  $concorsi_args = array(
    'post_type'=>'concorso',
    'posts_per_page'  => 5,
    'meta_key'		=> 'bando_archiviato',
	  'meta_value'	=> 0
  );
  $concorsi_posts = new WP_Query($concorsi_args);

  $gare_args = array(
    'post_type'=>'gara',
    'posts_per_page'  => 5,
    'meta_key'		=> 'bando_archiviato',
	  'meta_value'	=> 0
  );
  $gare_posts = new WP_Query($gare_args);
?>
<section class="home-section home-concorsi-gare">
  <div class="container">
    <div class="row">
      <div class="col-md-6">
        <?php if($title_concorso) echo '<h3 class="section-title">'.$title_concorso.'</h3>' ?>
        <div class="link-wrapper">
          <a href="#" class="btn view-more lblue toggler"><i class="icon-chevron-up"></i></a>
        </div>
        <?php if($concorsi_posts->have_posts()) : ?>
        <div class="teaser-list">
        <?php while($concorsi_posts->have_posts()) : $concorsi_posts->the_post();
          get_template_part('partials/teaser/_teaser', 'concorsi');
        endwhile; ?>
        </div>
        <?php endif;
        wp_reset_query();?>
        <?php if($link_concorsi) : ?>
          <?php if($pre_link_concorsi) echo '<h6 class="small-pre">'.$pre_link_concorsi.'</h6>';?>
          <div class="link-wrapper">
            <a href="<?php echo $link_concorsi;?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
          </div>
        <?php endif; ?>
      </div>
      <div class="col-md-6">
        <?php if($title_gara) echo '<h3 class="section-title">'.$title_gara.'</h3>' ?>
        <div class="link-wrapper">
          <a href="#" class="btn view-more lblue toggler"><i class="icon-chevron-up"></i></a>
        </div>
        <?php if($gare_posts->have_posts()) : ?>
          <div class="teaser-list">
            <?php while($gare_posts->have_posts()) : $gare_posts->the_post();
              get_template_part('partials/teaser/_teaser', 'concorsi');
            endwhile; ?>
          </div>
        <?php endif;
        wp_reset_query();?>
        <?php if($link_gare) : ?>
          <?php if($pre_link_gare) echo '<h6 class="small-pre">'.$pre_link_gare.'</h6>';?>
          <div class="link-wrapper">
            <a href="<?php echo $link_gare;?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div><!--container-->
</section><!--home-section-->

<script>
(function($){
  $(document).ready(function() {
    var $btn = $('.home-concorsi-gare').find('.toggler');
    $btn.click(function(e){
      e.preventDefault();
      $(this).toggleClass('closed');
      var $nextList = $(this).parent('.link-wrapper').next('.teaser-list');
      $nextList.slideToggle();
    })
  })
})(jQuery);
</script>
