<?php
/**
 * Template Name: Gare Scadute
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header();

while ( have_posts() ) : the_post(); ?>

<?php
  $gare_args = array(
    'post_type'=>'gara',
    'posts_per_page'  => -1
  );
  $gare_posts = new WP_Query($gare_args);
  $subtitle = get_field('sottotitolo');
?>

  <div class="container">
    <header class="page-header">
      <?php dueper_breadcrumbs(); ?>
      <h1 class="page-title"><?php the_title(); ?></h1>
      <?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
    </header>
  </div>

  <?php get_template_part('includes/_slider', 'internal'); ?>
  <div class="container page-content">
    <div class="row">
      <main class="col-md-8 col-md-push-4">
        <?php if($gare_posts->have_posts()) : ?>
        <div class="teaser-list">
        <?php while($gare_posts->have_posts()) : $gare_posts->the_post();
          if(get_field('bando_archiviato')) {
            get_template_part('partials/teaser/_teaser', 'concorsi');
          } endwhile; ?>
        </div>
        <?php endif;
        wp_reset_query();?>
      </main>
      <aside class="col-md-4 col-md-pull-8">
        <?php get_template_part('partials/_list-gare'); ?>
      </aside><!--col-md-84-->
    </div><!--row-->
  </div><!--container-->
  <?php
    $my_wp_query = new WP_Query();
    $all_wp_pages = $my_wp_query->query(array('post_type' => 'page', 'posts_per_page' => '-1'));
    $children = get_page_children( get_the_ID(), $all_wp_pages );
    if($children) : ?>
      <div class="container page-children">
        <div class="row">
        <?php foreach($children as $child) : ?>
          <div class="col-md-6 child-page">
            <?php echo '<h6 class="small-pre">'.get_the_title($child->ID).'</h6>';?>
            <div class="link-wrapper">
              <a href="<?php echo get_permalink($child->ID);?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>

<?php endwhile; ?>

<?php get_footer(); ?>
