<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>

<?php while ( have_posts() ) : the_post(); ?>
  <?php
    $subtitle = get_field('sottotitolo');
    $gallery_side = get_field('gallery_sidebar');
  ?>

  <div class="container">
    <header class="page-header">
      <?php dueper_breadcrumbs(); ?>
      <h1 class="page-title"><?php the_title(); ?></h1>
      <?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
    </header>
  </div>

  <?php get_template_part('includes/_slider', 'internal'); ?>
  <div class="container page-content">
    <div class="row">
      <?php if($gallery_side): ?>
      <main class="col-md-8 col-md-push-4">
        <div class="the-content">
          <?php get_template_part('partials/_content-override'); ?>
          <?php get_template_part('partials/_documents'); ?>
        </div>
      </main>
      <aside class="col-md-4 col-md-pull-8">
        <?php
        if( have_rows('gallery_sidebar') ):
          while ( have_rows('gallery_sidebar') ) : the_row();
            $img = get_sub_field('immagine');
            $desc = get_sub_field('didascalia'); ?>
            <figure class="sidebar-image">
              <?php if($img) echo '<img class="img-responsive" src="'.$img['sizes']['large'].'" />'?>
              <?php if($desc) echo '<figcaption>'.$desc.'</figcaption>'?>
            </figure>
          <?php endwhile;
        endif; ?>

      </aside><!--col-md-84-->
      <?php else: ?>
      <main class="col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1">
        <div class="the-content">
          <?php get_template_part('partials/_content-override'); ?>
          <?php get_template_part('partials/_documents'); ?>
        </div>
      </main>
      <?php endif; ?>
    </div><!--row-->
  </div><!--container-->
  <?php
    $my_wp_query = new WP_Query();
    $args = array(
      'post_type' => 'page',
      'posts_per_page' => '-1',
      'post_parent' => get_the_ID()
    );
    $all_wp_pages = $my_wp_query->query($args);
    $children = get_page_children( get_the_ID(), $all_wp_pages );
    if($children) : ?>
      <div class="container page-children">
        <div class="row">
        <?php foreach($children as $child) : ?>
          <div class="col-md-6 child-page">
            <?php echo '<h6 class="small-pre">'.get_the_title($child->ID).'</h6>';?>
            <div class="link-wrapper">
              <a href="<?php echo get_permalink($child->ID);?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>
    <?php wp_reset_query();?>
<?php endwhile; ?>

<?php get_footer(); ?>
