<?php
  $subtitle = get_field('sottotitolo');
?>

<div class="container">
  <header class="page-header">
    <?php dueper_breadcrumbs(); ?>
    <h1 class="page-title"><?php the_title(); ?></h1>
    <?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
  </header>
</div>

<?php get_template_part('includes/_slider', 'internal'); ?>
<div class="container page-content single-standard">
  <div class="row">
    <main class="col-md-8 col-md-push-4">
      <article>
        <figure>
          <?php the_post_thumbnail('large',array('class'=>'img-responsive')); ?>
        </figure>
        <div class="fig-caption">
          <div class="col-xs-6">
            <i class="icon-calendar"></i>
            <time><?php the_date('d/m/Y'); ?></time>
          </div>
          <div class="col-xs-6">
            <?php get_social_share();?>
          </div>
        </div>
        <div class="the-content">
          <?php get_template_part('partials/_content-override'); ?>
          <?php get_template_part('partials/_documents'); ?>
        </div>
      </article>
    </main>
    <aside class="col-md-4 col-md-pull-8">
      <?php get_template_part('partials/_list-categories');?>
    </aside ><!--col-md-4-->
  </div><!--row-->
</div><!--container-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
