<?php
  $color = get_field('color');
  $sub = get_field('sottotitolo');
  $classes = array ('post-teaser', 'service', $color );
?>

<article <?php post_class($classes); ?>>
  <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
    <figure>
      <?php the_post_thumbnail('loop-thumb', array('class'=>'img-responsive')); ?>
    </figure>
    <div class="content">
      <header>
        <a class="btn view-more <?php echo $color;?>" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><i class="icon-chevron-right"></i></a>
        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
          <h2>
            <?php the_title(); ?>
            <?php if($sub) echo '<small>'.$sub.'</small>'; ?>
          </h2>
      </a>
      </header>
    </div>
  </a>
</article><!--post-class-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
