<?php
  $subtitle = get_field('news_subtitle');
  $content = get_field('news_content');
  $pre_link = get_field('news_pre_link');
  $link = get_field('news_link');
?>
<section class="loop loop-news">
  <div class="container">
    <div class="row">
      <div class="col-md-8 col-md-offset-2 col-xs-10 col-xs-offset-1">
        <h3 class="section-title"><?php _e('News','dueper') ?></h3>
        <?php if($subtitle) echo '<h4 class="section-subtitle">'.$subtitle.'</h4>';?>
        <?php if($content) echo '<h5 class="section-content">'.$content.'</h5>';?>
      </div>
    </div>
    <?php
    $news_args = array(
      'post_type'=>'post',
      'posts_per_page'  => 3
    );
    $news_posts = new WP_Query($news_args);
    if ($news_posts->have_posts()) :
      echo '<div class="row posts">';
        while($news_posts->have_posts()) : $news_posts->the_post();
          echo '<div class="col-md-4 col-md-offset-0 col-sm-6 col-sm-offset-0 col-xs-10 col-xs-offset-1">';
            the_post_teaser();
          echo '</div><!--col-md-4-->';
        endwhile; ?>
      <?php echo '</div><!--row-->';
    endif;
    wp_reset_query();?>
    <div class="row">
      <div class="col-md-8 col-md-offset-2">
        <?php if($link) : ?>
          <?php if($pre_link) echo '<h6 class="small-pre">'.$pre_link.'</h6>';?>
          <div class="link-wrapper">
            <a href="<?php echo $link;?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div><!--container-->
</section><!--home-section-->
