<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>

<?php while ( have_posts() ) : the_post(); ?>
  <?php
    $subtitle = get_field('sottotitolo');
    $gallery_side = get_field('gallery_sidebar');
  ?>

  <div class="container">
    <header class="page-header">
      <?php dueper_breadcrumbs(); ?>
      <h1 class="page-title"><?php the_title(); ?></h1>
      <?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
    </header>
  </div>

  <?php get_template_part('includes/_slider', 'internal'); ?>
  <div class="container page-content">
    <div class="row">
      <?php if($gallery_side): ?>
      <main class="col-md-8 col-md-push-4">
        <div class="the-content">
          <?php get_template_part('partials/_content-override'); ?>
          <?php get_template_part('partials/_documents'); ?>
        </div>
      </main>
      <aside class="col-md-4 col-md-pull-8">
        <?php
        if( have_rows('gallery_sidebar') ):
          while ( have_rows('gallery_sidebar') ) : the_row();
            $img = get_sub_field('immagine');
            $desc = get_sub_field('didascalia'); ?>
            <figure class="sidebar-image">
              <?php if($img) echo '<img class="img-responsive" src="'.$img['sizes']['large'].'" />'?>
              <?php if($desc) echo '<figcaption>'.$desc.'</figcaption>'?>
            </figure>
          <?php endwhile;
        endif; ?>

      </aside><!--col-md-84-->
      <?php else: ?>
      <main class="col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1">
        <div class="the-content">
          <?php get_template_part('partials/_content-override'); ?>
          <?php get_template_part('partials/_documents'); ?>
        </div>
      </main>

      <main class="col-md-12">
        <hr />
        <div style="height: 20px;"></div>
        
        <div class="the-content">
          <?php
            get_template_part('partials/_amm-trasp-item-pages', null, [
              'page_id' => get_the_ID(),
              'show_parent' => false,
            ]);
          ?>
          </div>
          
        <div style="height: 50px;"></div>
          
      </main>

      <?php endif; ?>
    </div><!--row-->
  </div><!--container-->


    <?php wp_reset_query();?>
<?php endwhile; ?>

<?php get_footer(); ?>
