<?php
$page_id = $args['page_id'];
$show_parent = $args['show_parent'] ?? true;
//get term childre
$children = new WP_Query([
  'post_type' => 'page',
  'posts_per_page' => 1000,
  'post_parent' => $page_id,
]);
?>

<div class="
  term-item
  <?php if ($children->have_posts() && $show_parent) echo 'collapsable' ?>
  "
  <?php if ($children && $show_parent): ?>
    data-collapsable="<?php echo $page_id; ?>"
  <?php endif; ?>
>
  <?php if ($children->have_posts()) : ?>

      <div class="term-item-header">
        <button <?php echo $show_parent ? 'data-collapsable-button="' . $page_id . '"' : ''; ?>>
          <div class="ball blue">
            <i class="icon-plus"></i>
            <i class="icon-minus" style="display: none;"></i>
          </div>
        </button>
        <?php if ($show_parent): ?>
          <a href="<?php echo get_the_permalink($page_id); ?>" style="display: flex;">
        <?php endif; ?>
          <?php echo '<h6>' . get_the_title($page_id) . '</h6>'; ?>
          <?php if (is_user_logged_in()) echo '<span style="color: #999; font-size: 12px; margin-left: 1rem;">Pagina</span>'; ?>
        <?php if ($show_parent): ?>
          </a>
        <?php endif; ?>
        <?php if (is_user_logged_in()) : ?>
          <div style="font-size: 12px; margin-left: 10px; text-decoration: underline;">
            <?php edit_post_link('Modifica', '<span class="edit-link">', '</span>', $page_id); ?>
          </div>
        <?php endif; ?>
      </div>
    <div class="term-item-children" data-collapsable-content="<?php echo $page_id; ?>" style="display: <?php echo $show_parent ? 'none' : 'block'; ?>">
      <?php while ($children->have_posts()) : $children->the_post();
        // var_dump(get_the_ID());
        get_template_part('partials/_amm-trasp-item-pages', null, [
          'page_id' => get_the_ID(),
        ]);
      endwhile; ?>
    </div>
  <?php else : ?>
    <div class="term-item-header">
      <div class="ball gray">
        <i class="icon-chevron-right"></i>
      </div>
      <a href="<?php echo get_the_permalink($page_id); ?>" style="display: flex;">
        <?php echo '<h6>' . get_the_title($page_id) . '</h6>'; ?>
        <?php if (is_user_logged_in()) echo '<span style="color: #999; font-size: 12px; margin-left: 1rem;">Pagina</span>'; ?>
      </a>
      <?php if (is_user_logged_in()) : ?>
        <div style="font-size: 12px; margin-left: 10px; text-decoration: underline;">
          <?php edit_post_link('Modifica', '<span class="edit-link">', '</span>', $page_id); ?>
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>

<?php wp_reset_query();?>