<?php
/**
 * The template for displaying search forms in upBootWP
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
?>
<form role="search" method="get" class="search-form form-inline" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<div class="form-group">
		<input type="search" id="searchinput" class="search-field form-control" placeholder="<?php echo esc_attr_x( 'Cerca', 'placeholder', 'dueper' ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" title="<?php _ex( 'Cerca', 'label', 'dueper' ); ?>">
	</div>
	<input type="submit" class="search-submit btn btn-primary" value="<?php echo esc_attr_x( 'Cerca', 'submit button', 'dueper' ); ?>">
</form>
