<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

$args = array(
  'post_type' => 'gara',
  'meta_query' => array(
    array(
      'key'     => 'bando_archiviato',  // Nome del campo personalizzato
      'value'   => '0',     // Valore da filtrare
      'compare' => '=',         // Operatore di confronto
    ),
  ),
  'tax_query' => array(
    array(
      'taxonomy' => 'gara_category', // Sostituisci "nome_tassonomia" con il nome corretto della tassonomia
      'field'    => 'slug', // Puoi usare 'term_id', 'slug' o 'name' a seconda del valore con cui desideri confrontare la tassonomia
      'terms'    => get_queried_object()->slug, // Ottiene lo slug dell'oggetto tassonomia corrente
    ),
  ),
);

$query = new WP_Query( $args );

get_header(); ?>
<header class="page-header">
  <div class="container">
    <?php dueper_breadcrumbs(); ?>
    <h1 class="page-title">
        <?php
          if ( is_category() ) :
              single_cat_title();

          elseif ( is_tax() ) :
              single_term_title();

          elseif ( is_post_type_archive() ) :
              post_type_archive_title();

          elseif ( is_tag() ) :
              single_tag_title();

          elseif ( is_author() ) :
              /* Queue the first post, that way we know
               * what author we're dealing with (if that is the case).
              */
              the_post();
              printf( __( 'Author: %s', 'dueper' ), '<span class="vcard">' . get_the_author() . '</span>' );
              /* Since we called the_post() above, we need to
               * rewind the loop back to the beginning that way
               * we can run the loop properly, in full.
               */
              rewind_posts();

          elseif ( is_day() ) :
              printf( __( 'Day: %s', 'dueper' ), '<span>' . get_the_date() . '</span>' );

          elseif ( is_month() ) :
              printf( __( 'Month: %s', 'dueper' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

          elseif ( is_year() ) :
              printf( __( 'Year: %s', 'dueper' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

          elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
              _e( 'Asides', 'dueper' );

          elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
              _e( 'Images', 'dueper');

          elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
              _e( 'Videos', 'dueper' );

          elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
              _e( 'Quotes', 'dueper' );

          elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
              _e( 'Links', 'dueper' );

          else :
              _e( 'Archives', 'dueper' );

          endif;
      ?>
      </h1>
    </div><!--container-->
</header><!-- .page-header -->


<div class="container page-content">
  <div class="row">
    <main class="col-md-8 col-md-push-4">
      <?php if ( $query->have_posts() ) :
        while ( $query->have_posts() ) : $query->the_post();
        get_template_part('partials/teaser/_teaser', 'concorsi');
        endwhile;
      endif;
      wp_reset_query();?>
      <div class="clearfix"></div>
      <?php if(function_exists('wp_pagenavi')):
        wp_pagenavi();
      endif;?>
    </main><!--col-md-8-->
    <!-- <aside class="col-md-4 col-md-pull-8">
      <?php //get_template_part('partials/_list-categories');?>
    </aside> -->
    <aside class="col-md-4 col-md-pull-8">
      <?php get_template_part('partials/_list-gare'); ?>
    </aside><!--col-md-84-->
  </div><!--row-->
</div><!--container-->
<div class="container">
  <?php
  $term = get_term(get_queried_object()->term_id);
  $term_id = $term->term_id;
  $taxonomy_name = $term->taxonomy;
  $children = get_terms( $taxonomy_name,
    array(
      'parent' => get_queried_object_id(),
    ) );
    if( ! is_wp_error($children)) : ?>
      <div class="container page-children">
        <div class="row">
        <?php foreach($children as $child) : ?>
          <?php //$child_term = get_term_by( 'id', $child, $taxonomy_name ); ?>
          <div class="col-md-6 child-page">
            <?php echo '<h6 class="small-pre">'.$child->name.'</h6>';?>
            <div class="link-wrapper">
              <a href="<?php echo get_term_link( $child, $taxonomy_name );?>" class="btn view-more lblue"><i class="icon-chevron-right"></i></a>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
      </div>
    <?php endif; ?>
    <?php wp_reset_query();?>
</div>
<?php get_footer(); ?>
