<?php
require_once(get_template_directory().'/functions/admin/editor-custom-style/custom-style.php');


// Remove upgrade alert in backend
if ( !function_exists('wphidenag')) {
  add_action('admin_menu','wphidenag');
  function wphidenag() {
    remove_action( 'admin_notices', 'update_nag', 3 );
  }
}

// Custom login in admin login page
if ( !function_exists('my_custom_login_url')) {
  add_filter( 'login_headerurl', 'my_custom_login_url', 10 , 2 );
  function my_custom_login_url($url) {
    $siteURL = esc_url(home_url());
    return $siteURL;
  }
}


//Custom logo in login page
if ( !function_exists('dueper_custom_loginlogo')) {
  add_action('login_head', 'dueper_custom_loginlogo');
  function dueper_custom_loginlogo() {
    $logo_img = get_field('logo_image','option');
    if($logo_img):
      $img = $logo_img['sizes']['medium'];
    else:
      $img = get_template_directory_uri().'/img/login-logo.png';
    endif;


    echo '<style type="text/css">
    body {
      background-color: #F7F7F7 !important;
    }
    h1 a {
      background-image: url('.$img.') !important;
      background-size: contain !important;
      background-position: center !important;
      height: 0 !important;
      padding-bottom: 30% !important;
      width: 80% !important;
    }</style>';
  }
}

// Custom Footer text in back-end
if ( !function_exists('remove_footer_admin')) {
  add_filter('admin_footer_text', 'remove_footer_admin', 10, 1);
  function remove_footer_admin () {
    $theme = wp_get_theme();
    echo 'Creato da <a href="'.$theme->get( 'AuthorURI' ) .'" target="_blank">'.$theme->get( 'Author' ).'</a> a partire da <a href="http://www.wordpress.org" target="_blank">WordPress</a></p>';
  }
}

// Disable widget in admin dashboard
if ( !function_exists('dueper_remove_dashboard_widgets')) {
  add_action('wp_dashboard_setup', 'dueper_remove_dashboard_widgets' );
  function dueper_remove_dashboard_widgets() {
    global $wp_meta_boxes;
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']); // disabilito quick press nella dashboard
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']); // disabilito Link in entrata nella dashboard
    //unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']); // disabilito Riassunto sito (numero di post/commenti ecc..) nella dashboard
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']); // disabilito widget plugin nella dashboard
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']); // disabilito widget Bozze recenti nella dashboard
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']); // disabilito widget dei commenti recenti nella dashboard
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']); // disabilito widget Wordpress Blog nella dashboard
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']); // disabilito widget Other Wordpress news nella dashboard
  }
}
// Add widget in Admin dashboard
if ( !function_exists('dueper_dashboard_widgets')) {
  add_action('wp_dashboard_setup', 'dueper_dashboard_widgets');
  function dueper_dashboard_widgets() {
    global $wp_meta_boxes;
    wp_add_dashboard_widget('dueper_help_widget', 'Hai bisogno di aiuto?', 'dueper_dashboard_help');
  }
  function dueper_dashboard_help() {
    echo '<p><h2>Hai riscontrato dei problemi che non rieci a risolvere?</h2><br /><a href="http://www.dueper.net" target="_blank" class="button button-primary button-large">Contattaci</a></p>';
  }
}

// Replace Howdy with custom text
if ( !function_exists('wp_admin_bar_my_custom_account_menu')) {
  add_action( 'admin_bar_menu', 'wp_admin_bar_my_custom_account_menu', 11 );
  function wp_admin_bar_my_custom_account_menu( $wp_admin_bar ) {
    $user_id = get_current_user_id();
    $current_user = wp_get_current_user();
    $profile_url = get_edit_profile_url( $user_id );
    if ( 0 != $user_id ) :
      /* Add the "My Account" menu */
      $avatar = get_avatar( $user_id, 28 );
      $howdy = sprintf( __('YO! %1$s', 'dueper'), $current_user->display_name );
      $class = empty( $avatar ) ? '' : 'with-avatar';

      $wp_admin_bar->add_menu( array(
        'id' => 'my-account',
        'parent' => 'top-secondary',
        'title' => $howdy . $avatar,
        'href' => $profile_url,
        'meta' => array(
        'class' => $class,
        ),
        ));
    endif;
  }
}

add_action('admin_menu', 'add_custom_menu_link_clear_administration');
function add_custom_menu_link_clear_administration()
{
    add_menu_page('clear_administration_link', 'Amministrazione trasparente', 'read', "&#47;wp/wp-admin/edit-tags.php?taxonomy=clear_administration", '', 'dashicons-text', 2);
}