<?php
  $color = get_field('color');
  $subtitle = get_field('sottotitolo');
  $cosa = get_field('cosa_e');
  $offerta = get_field('cosa_offre');
  $costo = get_field('quanto_costa');
  $info = get_field('a_chi_chiedere');
  $quote_img = get_field('immagine_citazione');
  $quote_txt = get_field('testo_citazione');
?>


<div class="container">
  <header class="page-header">
    <?php dueper_breadcrumbs(); ?>
    <h1 class="page-title"><?php the_title(); ?></h1>
    <?php if($subtitle) echo '<h2 class="page-subtitle">'.$subtitle.'</h2>'; ?>
  </header>
</div>

<?php get_template_part('includes/_slider', 'internal'); ?>
<div class="container page-content">
  <div class="row">
    <main class="col-md-8 col-md-push-4">
      <article>
        <div class="the-content">
          <?php if($cosa): ?>
            <div class="text-block">
              <h4 class="block-title"><?php _e('Cosa è', 'Dueper');?></h4>
              <?php echo $cosa;?>
            </div>
          <?php endif; ?>
          <?php if($offerta): ?>
            <div class="text-block">
              <h4 class="block-title"><?php _e('Cosa offre', 'Dueper');?></h4>
              <?php echo $offerta;?>
            </div>
          <?php endif; ?>
          <?php if($costo): ?>
            <div class="text-block">
              <h4 class="block-title"><?php _e('Quanto costa', 'Dueper');?></h4>
              <?php echo $costo;?>
            </div>
          <?php endif; ?>
          <?php if($info): ?>
            <div class="text-block">
              <h4 class="block-title"><?php _e('A chi chiedere informazioni', 'Dueper');?></h4>
              <?php echo $info;?>
            </div>
          <?php endif; ?>
          <?php get_template_part('partials/_documents'); ?>
        </div>
      </article>
    </main>
    <aside class="col-md-4 col-md-pull-8">
      <?php
        if( have_rows('persone_associate') ):
          while ( have_rows('persone_associate') ) : the_row();
            $person = get_sub_field('persona');
            $desc = get_sub_field('descrizione'); ?>
            <?php if($person):
              $post = $person;
              setup_postdata($post);
              $title = get_field('titolo');
            ?>
              <div class="person-wrapper <?php if($color) echo $color;?>">
              <?php
                the_post_thumbnail('loop-thumb', array('class' => 'img-responsive') );
                echo '<div class="person-infos">';
                if($title) echo '<span class="info">'.$title.'</span>';
                the_title('<span class="info title">','</span>');
              ?>
              <?php wp_reset_postdata();
            endif; ?>
            <?php if($desc) echo '<span class="info">'.$desc.'</span>'; ?>
            </div><!-- infos -->
          </div><!-- wrapper -->
          <?php endwhile;
        endif;
        ?>
      <?php if($quote_txt || $quote_img): ?>
        <div class="quote-wrapper <?php if($color) echo $color; ?>">
          <?php if($quote_img) echo '<figure><img class="img-responsive" src="'.$quote_img['sizes']['loop-thumb'].'" /></figure>'; ?>
          <?php if($quote_txt) echo '<span class="quote-mark open">&ldquo;</span>'.$quote_txt.'<span class="quote-mark close">&rdquo;</span>';?>
        </div>
      <?php endif;?>
    </aside><!--col-md-4-->
  </div><!--row-->
</div><!--container-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
