<?php
  $classes = array ('post-teaser', 'struttura' );
  $role = get_field('ruolo');
  $title = get_field('titolo');
  $mail = get_field('e_mail');
?>

<article <?php post_class($classes); ?>>
  <figure>
    <?php the_post_thumbnail('loop-thumb', array('class'=>'img-responsive')); ?>
    <header>
      <h2>
        <?php if($title) echo '<small>'.$title.'</small>'; ?>
        <?php the_title(); ?>
      </h2>
    </header>
  </figure>
  <div class="content">
    <?php if($role) echo '<h4 class="role">'.$role.'</h4>'; ?>
    <?php the_content();?>
    <hr />
    <?php if($mail) echo '<i class="icon-mail"></i><a class="email" href="mailto:'.$mail.'">'.$mail.'</a>';?>
  </div>
</article><!--post-class-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
