<?php
// if ( !function_exists('has_children')) {
//   function has_children() {
//     global $post;
//     $pages = get_pages('child_of=' . $post->ID);
//     return count($pages);
//   }
// }

if ( !function_exists('dueper_breadcrumbs')) {
  function dueper_breadcrumbs() {
    global $post;
    global $wp_query;
    
    $color = get_field('color');
    $delimiter = '<i class="icon-chevron-right"></i>';
    $home = 'Home';
    $before = '<li class="active">';
    $after = '</li>';

    if (
      (is_page() && !$post->post_parent==0) ||
      (is_category() && $wp_query->get_queried_object()->parent == 0)
    ) {
      echo '<ul class="breadcrumb">';
      if($color): echo '<div class="circle '.$color.'"></div>';
      else : echo '<div class="circle"></div>';
      endif;
      echo '</ul>';
      //return;
    }


    // CLEAR ADMINISTRATION custom breadcrumbs
    if(has_term('','clear_administration')) : ?>
    <?php
      $custom_taxonomy    = 'clear_administration';
    ?>
      <ul class="breadcrumb clear">
        <li><a href="<?php echo home_url(); ?>/amministrazione-trasparente"><?php _e('Amministrazione Trasparente') ;?></a></li>
        <?php
        $taxonomy_exists = taxonomy_exists($custom_taxonomy);
          if($taxonomy_exists) {
            $taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy );
            $cat_id         = $taxonomy_terms[0]->term_id;
            $cat_nicename   = $taxonomy_terms[0]->slug;
            $cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
            $cat_name       = $taxonomy_terms[0]->name;
            $cat_parent     = $taxonomy_terms[0]->parent;
            $parent         = get_term($cat_parent, $custom_taxonomy );
            $cat_parent_name = $parent->name;
            $cat_parent_link = get_term_link($cat_parent, $custom_taxonomy);
            // var_dump($cat_parent);
            // if post is in a custom taxonomy

            $page_linked = get_posts([
              'post_type' => 'page',
              'posts_per_page' => 1,
              'tax_query' => [
                  [
                    'taxonomy' => 'clear_administration',
                    'field' => 'term_id',
                    'terms' => $cat_id,
                    'include_children' => false,
                  ]
                ]
            ]);

            $page_linked = count($page_linked) > 0 ? $page_linked[0] : null;
            $cat_link = $page_linked ? get_the_permalink($page_linked) : $cat_link;

            if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {

              if ( $cat_parent ) {
                echo '<li class="item-current item"><a href="' . $cat_parent_link . '" >' . $cat_parent_name . '</a></li>';
              } else {
                echo '<li class="item-current item">' . $cat_name . '</li>';
              }

            } elseif($cat_parent && !empty($cat_id)) {
              echo '<li class="item-current item"><a href="' . $cat_parent_link . '" >' . $cat_parent_name . '</a></li>';
              echo '<li class="item-current item"><a href="' . $cat_link . '" >' . $cat_name . '</a></li>';
              echo '<li class="item-current item">' . get_the_title() . '</li>';
            } elseif(!empty($cat_id)) {
              echo '<li class="item-current item"><a href="' . $cat_link . '" >' . $cat_name . '</a></li>';
              echo '<li class="item-current item">' . get_the_title() . '</li>';
            } else {

              echo '<li class="item-current item-' . $post->ID . '">' . get_the_title() . '</li>';
            }
          }
        // $terms = get_the_terms($post, 'clear_administration');
        // foreach($terms as $term) {
        //   $tmpTerm = $term;
        //   $tmpCrumbs = array();
        //   while ($tmpTerm->parent != 0) {
        //     $tmpTerm = get_term($tmpTerm->parent, 'clear_administration');
        //     $crumb = '<li><a href="' . get_term_link($tmpTerm, 'clear_administration') . '">' . $tmpTerm->name . '</a></li>';
        //     array_push($tmpCrumbs, $crumb);
        //   }
        // }
        // echo implode('', array_reverse($tmpCrumbs));
        // echo '<li><a href="' . get_term_link($term, 'clear_administration') . '">' . $term->name . '</a></li>';
        ?>
      </ul>

    <?php endif; ?>


    <?php if (
			//!is_home() && !is_front_page()
			// || is_paged()
			//|| 
			(is_page() && !$post->post_parent==0)
      		|| (is_category() && $wp_query->get_queried_object()->parent == 0)) {
      echo '<ol class="breadcrumb">';
      $homeLink = esc_url(home_url());
      echo '<li><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . '</li> ';
      if (is_category()) {
        $cat_obj = $wp_query->get_queried_object();
        $thisCat = $cat_obj->term_id;
        $thisCat = get_category($thisCat);
        $parentCat = get_category($thisCat->parent);
        if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
        echo $before . single_cat_title('', false) . $after;
      } elseif (is_day()) {
        echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
        echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_time('d') . $after;
      } elseif (is_month()) {
        echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_time('F') . $after;
      } elseif (is_year()) {
        echo $before . get_the_time('Y') . $after;
      } elseif (is_single() && !is_attachment()) {
        if ( get_post_type() != 'post' ) {
          $post_type = get_post_type_object(get_post_type());
          $slug = $post_type->rewrite;
          echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li> ' . $delimiter . ' ';
          $terms = get_the_terms($post, 'gara_category');
          if ($terms && !is_wp_error($terms)) {
            $term = $terms[0];
            $taxonomy = 'gara_category';
            $parents = array();

            while ($term->parent) {
              $parents[] = $term;
              $term = get_term($term->parent, $taxonomy);
            }

            if (!empty($parents)) {
              $parents = array_reverse($parents);
              foreach ($parents as $parent) {
                echo '<li><a href="' . get_term_link($parent, $taxonomy) . '">' . $parent->name . '</a>' . $delimiter . '</li>';
              }
            }

            echo '<li><a href="' . get_term_link($term, $taxonomy) . '">' . $term->name . '</a>' . $delimiter . '</li>';
          }
          echo $before . get_the_title() . $after;
        } else {
          $cat = get_the_category(); $cat = $cat[0];
          echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
          echo $before . get_the_title() . $after;
        }
      } elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
        $post_type = get_post_type_object(get_post_type());
        echo $before . $post_type->labels->singular_name . $after;
      } elseif (is_attachment()) {
        $parent = get_post($post->post_parent);
        $cat = get_the_category($parent->ID); $cat = $cat[0];
        echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
        echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_title() . $after;
      } elseif ( is_page() && !$post->post_parent ) {
        echo $before . get_the_title() . $after;
      } elseif ( is_page() && $post->post_parent ) {
        $parent_id  = $post->post_parent;
        $breadcrumbs = array();
        while ($parent_id) {
          $page = get_page($parent_id);
          $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
          $parent_id  = $page->post_parent;
        }
        $breadcrumbs = array_reverse($breadcrumbs);
        foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
        echo $before . get_the_title() . $after;
      } elseif ( is_search() ) {
        echo $before . 'Search results for "' . get_search_query() . '"' . $after;
      } elseif ( is_tag() ) {
        echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
      } elseif ( is_author() ) {
        global $author;
        $userdata = get_userdata($author);
        echo $before . 'Articles posted by ' . $userdata->display_name . $after;
      } elseif ( is_404() ) {
        echo $before . 'Error 404' . $after;
      }
      if ( get_query_var('paged') ) {
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
        echo ': ' . __('Page', 'dueper') . ' ' . get_query_var('paged');
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
      }
      if($color): echo '<div class="circle '.$color.'"></div>';
      else : echo '<div class="circle"></div>';
      endif;
      echo '</ol>';
    }
  }
}
