<section class="loop loop-servizi">
  <?php if( have_rows('service_list', 'option') ): ?>
  <div class="container">
    <?php while( have_rows('service_list', 'option') ): the_row(); ?>
    <?php $row_title = get_sub_field('category_title'); ?>
    <div class="row">
      <div class="col-md-8 col-md-offset-2 col-xs-10 col-xs-offset-1">
        <?php if($row_title) echo '<h3 class="section-title">'.$row_title.'</h3>'; ?>
      </div>
    </div>

      <?php
      if (have_rows('service_row')) :
        echo '<div class="row">';
          while( have_rows('service_row') ): the_row();
            $img = get_sub_field('immagine');
            $servizio = get_sub_field('servizio');
            $post = $servizio;
            setup_postdata($post);

            echo '<div class="col-md-4 col-md-offset-0 col-sm-6 col-sm-offset-0 col-xs-10 col-xs-offset-1">';
              $color = get_field('color');
              $classes = array ('post-teaser', 'service', $color );
              $sub = get_field('sottotitolo');
            ?>

            <article <?php post_class($classes); ?>>
              <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                <figure>
                  <?php if($img):?>
                    <img class="img-responsive" src="<?php echo $img['sizes']['loop-thumb'];?>">
                  <?php else: ?>
                    <?php the_post_thumbnail('loop-thumb', array('class'=>'img-responsive')); ?>
                  <?php endif; ?>
                </figure>
                <div class="content">
                  <header>
                    <a class="btn view-more <?php echo $color;?>" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><i class="icon-chevron-right"></i></a>
                    <h2>
                      <?php the_title(); ?>
                      <?php if($sub) echo '<small>'.$sub.'</small>'; ?>
                    </h2>
                  </header>
                </div>
              </a>
            </article><!--post-class-->

            <?php if( function_exists('the_blogpost_json_ld') ):
              the_blogpost_json_ld($post->ID);
            endif; ?>

            <?php echo '</div><!--col-md-4-->';

            wp_reset_postdata();
          endwhile;
        echo '</div><!--row-->';
      endif; ?>

      <?php endwhile; ?>
    </div><!--container-->
  <?php endif; ?>
</section><!--home-section-->
