<?php
require_once(get_template_directory().'/functions/init/init-func-plugin-dependencies.php');
require_once(get_template_directory().'/functions/init/init-func-custom-post-types.php');
require_once(get_template_directory().'/functions/init/init-func-taxonomies.php');
//require_once(get_template_directory().'/functions/init/init-func-custom-fields.php');
require_once(get_template_directory().'/functions/init/init-func-widget.php');
require_once(get_template_directory().'/functions/init/init-func-menu.php');
require_once(get_template_directory().'/functions/init/init-func-thumbnails.php');
require_once(get_template_directory().'/functions/init/init-func-enqueue-files.php');
require_once(get_template_directory().'/functions/init/init-func-redirect.php');

load_theme_textdomain('dueper', get_template_directory().'/languages');

add_theme_support( 'automatic-feed-links' );
add_theme_support( 'title-tag' );
add_theme_support( 'html5', array('search-form', 'comment-form','comment-list','gallery','caption' ));
//add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );

add_filter( 'parse_tax_query', 'no_childs_terms' );
function no_childs_terms( $query ) {
    if (
        ! is_admin()
        && $query->is_main_query()
        && $query->is_tax( 'clear_administration' )
    ) {
        $query->tax_query->queries[0]['include_children'] = 0;
    }
}


if( function_exists('acf_add_options_page') ) {
    if (!function_exists('dueper_add_options_pages')) {
      add_action( 'init', 'dueper_add_options_pages' );
      function dueper_add_options_pages(){
        $general_conf = acf_add_options_page(array(
          'page_title' 	=> 'Configurazioni generali',
          'menu_title' 	=> 'Configurazioni',
          'menu_slug' 	=> 'theme-general-conf',
          'capability' 	=> 'edit_others_pages',//Editor
          'redirect'    => true,
          'icon_url'    => 'dashicons-welcome-view-site'
        ));
  
        acf_add_options_sub_page(array(
          'page_title' 	=> 'Opzioni generali',
          'menu_title' 	=> 'Generali',
          'parent_slug' 	=> $general_conf['menu_slug'],
        ));
        acf_add_options_sub_page(array(
          'page_title' 	=> 'Opzioni avanzate',
          'capability'  => 'update_core',
          'menu_title' 	=> 'Avanzate',
          'parent_slug' 	=> $general_conf['menu_slug'],
        ));
  
        $social_page = acf_add_options_page(array(
          'page_title' 	=> 'Account social',
          'menu_title' 	=> 'Social',
          'menu_slug' 	=> 'theme-social-account',
          'capability' 	=> 'edit_others_pages',//Editor
          'redirect'    => true,
          'icon_url'    => 'dashicons-share'
        ));
  
        //Add custom field group
    //     require_once(get_template_directory().'/functions/init/custom-fields/general.php');
    //     require_once(get_template_directory().'/functions/init/custom-fields/advanced.php');
    //     require_once(get_template_directory().'/functions/init/custom-fields/social-accounts.php');
       }
    }
  }