<?php
/**
 * Template Name: Amministrazione Trasparente
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>

<?php while (have_posts()):
  the_post(); ?>
  <?php
  $subtitle = get_field('sottotitolo');
  $gallery_side = get_field('gallery_sidebar');
  $amm_terms = get_terms(array(
    'taxonomy' => 'clear_administration',
    'hide_empty' => true,
    'parent' => 0,
  ));
  ?>

  <div class="container">
    <header class="page-header">
      <?php dueper_breadcrumbs(); ?>
      <h1 class="page-title"><?php the_title(); ?></h1>
      <?php if ($subtitle)
        echo '<h2 class="page-subtitle">' . $subtitle . '</h2>'; ?>
    </header>
  </div>

  <?php get_template_part('includes/_slider', 'internal'); ?>
  <div class="container page-content">
    <div class="row">
      <?php if ($gallery_side): ?>
        <main class="col-md-8 col-md-push-4">
          <div class="the-content">
            <?php get_template_part('partials/_content-override'); ?>
            <?php get_template_part('partials/_documents'); ?>
            <hr />
            <?php
            foreach ($amm_terms as $amm_term): ?>
              <div class="col-xs-6 term-child">
                <?php echo '<h6 class="small-pre">' . get_the_title($amm_term->ID) . '</h6>'; ?>
                <div class="link-wrapper">
                  <a href="<?php echo get_permalink($amm_term->ID); ?>" class="btn view-more lblue"><i
                      class="icon-chevron-right"></i></a>
                </div>
              </div>
            <?php endforeach; ?>

          </div>
        </main>
        <aside class="col-md-4 col-md-pull-8">
          <?php
          if (have_rows('gallery_sidebar')):
            while (have_rows('gallery_sidebar')):
              the_row();
              $img = get_sub_field('immagine');
              $desc = get_sub_field('didascalia'); ?>
              <figure class="sidebar-image">
                <?php if ($img)
                  echo '<img class="img-responsive" src="' . $img['sizes']['large'] . '" />' ?>
                <?php if ($desc)
                  echo '<figcaption>' . $desc . '</figcaption>' ?>
                </figure>
            <?php endwhile;
          endif; ?>

        </aside><!--col-md-84-->
      <?php else: ?>
        <main class="col-md-12">
          <div class="the-content">
            <?php get_template_part('partials/_content-override'); ?>
            <?php get_template_part('partials/_documents'); ?>

            <div style="height: 20px;"></div>
            <hr />
            <div style="height: 20px;"></div>

            <?php
            foreach ($amm_terms as $amm_term):
              get_template_part('partials/_amm-trasp-item', null, [
                'term' => $amm_term,
              ]);
              ?>
            <?php endforeach;
            ?>
          </div>
        </main>
      <?php endif; ?>
    </div><!--row-->
  </div><!--container-->

<?php endwhile; ?>

<?php get_footer(); ?>