<?php
$term = $args['term'];
$startOpened = $args['startOpened'] ?? false;

//get term childre
$term_children = get_terms([
  'taxonomy' => 'clear_administration',
  'hide_empty' => true,
  'parent' => $term->term_id,
]);

// var_dump(array_map(function($term) {
//   return $term->name;
// }, $term_children));


$pages = new WP_Query([
  'post_type' => 'page',
  'posts_per_page' => 1000,
  'tax_query' => [
    [
      'taxonomy' => 'clear_administration',
      'field' => 'term_id',
      'terms' => $term->term_id,
      'include_children' => false,
    ]
  ]
]);

$has_children = (!is_wp_error($term_children) && count($term_children) > 0) || $pages->have_posts();

?>


<div class="
  term-item
  <?php if ($has_children)
    echo 'collapsable' ?>
  <?php if ($startOpened)
    echo 'open' ?>
  " <?php if ($has_children): ?> data-collapsable="<?php echo $term->term_id; ?>" <?php endif; ?>>
  <?php if ($has_children): ?>
    <div class="term-item-header">
      <button data-collapsable-button="<?php echo $term->term_id; ?>">
        <div class="ball blue">
          <i class="icon-plus"></i>
          <i class="icon-minus"></i>
        </div>
      </button>
      <!-- <a href="<?php echo get_term_link($term); ?>" style="display: flex;"> -->
      <?php echo '<h6>' . $term->name . '</h6>'; ?>
      <?php if (is_user_logged_in())
        echo '<span style="color: #999; font-size: 12px; margin-left: 1rem;">Tassonomia</span>'; ?>
      <!-- </a> -->
      <?php if (is_user_logged_in()): ?>
        <div style="font-size: 12px; margin-left: 10px; text-decoration: underline;">
          <?php edit_term_link('Modifica', '<span class="edit-link">', '</span>', $term); ?>
        </div>
      <?php endif; ?>
    </div>
    <div class="term-item-children" data-collapsable-content="<?php echo $term->term_id; ?>" <?php if (!$startOpened)
         echo 'style="display: none;"' ?>>

        <?php
       while ($pages->have_posts()):
         $pages->the_post();
         get_template_part('partials/_amm-trasp-item-pages', null, [
           'page_id' => get_the_ID(),
           'show_parent' => !$startOpened,
         ]);
       endwhile;
       ?>
      <?php foreach ($term_children as $term_child):
        get_template_part('partials/_amm-trasp-item', null, [
          'term' => $term_child,
        ]);
      endforeach; ?>
    </div>
  <?php else: ?>

    <div class="term-item-header">
      <div class="ball gray">
        <i class="icon-chevron-right"></i>
      </div>
      <!-- <a href="<?php echo get_term_link($term); ?>"> -->
      <?php echo '<h6>' . $term->name . '</h6>'; ?>
      <?php if (is_user_logged_in())
        echo '<span style="color: #999; font-size: 12px; margin-left: 1rem;">Tassonomia</span>'; ?>
      <!-- </a> -->
      <div style="font-size: 12px; margin-left: 10px; text-decoration: underline;">
        <?php edit_term_link('Modifica', '<span class="edit-link">', '</span>', $term); ?>
      </div>
    </div>
  <?php endif; ?>


</div>