<?php
namespace App;

function thor_blocks_callback($block, $content = '', $is_preview = false, $post_id = 0 ) {
  $slug = str_replace('acf/', '', $block['name']);
  $block['slug'] = $slug;
  $block['classes'] = implode(' ', [$block['slug'], $block['className'], 'align'.$block['align']]);
  $template = null;
  $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
    return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    
  $data['block'] = $block;
  $data['content'] = $content;
  $data['is_preview'] = $is_preview;
  $data['post_id'] = $post_id;
  echo \App\template("blocks/${slug}", $data);
}
// Register custom blocks
if( function_exists('acf_register_block_type') ) {

  add_action('init', function () {

    acf_register_block_type(array(
      'name'              => 'Decor List',
      'title'             => __('Decor List', 'thor'),
      'description'       => __('Custom block that shows a list of decors', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Decors list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Video Player Embed',
      'title'             => __('Video Player Embed', 'thor'),
      'description'       => __('Lets you embed a video from URL', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M18.7 3H5.3C4 3 3 4 3 5.3v13.4C3 20 4 21 5.3 21h13.4c1.3 0 2.3-1 2.3-2.3V5.3C21 4 20 3 18.7 3zm.8 15.7c0 .4-.4.8-.8.8H5.3c-.4 0-.8-.4-.8-.8V5.3c0-.4.4-.8.8-.8h13.4c.4 0 .8.4.8.8v13.4zM10 15l5-3-5-3v6z"></path></svg>',
      'keywords'          => array( 'Decors list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Download List',
      'title'             => __('Download List', 'thor'),
      'description'       => __('Custom block that shows a list of Download', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M11.1 15.8H20v-1.5h-8.9v1.5zm0-8.6v1.5H20V7.2h-8.9zM6 13c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-7c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"></path></svg>',
      'keywords'          => array( 'Download list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'lottie-animation',
      'title'             => __('Lottie animation', 'thor'),
      'description'       => __('Custom block that lets you use Lottie', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M18.7 3H5.3C4 3 3 4 3 5.3v13.4C3 20 4 21 5.3 21h13.4c1.3 0 2.3-1 2.3-2.3V5.3C21 4 20 3 18.7 3zm.8 15.7c0 .4-.4.8-.8.8H5.3c-.4 0-.8-.4-.8-.8V5.3c0-.4.4-.8.8-.8h13.4c.4 0 .8.4.8.8v13.4zM10 15l5-3-5-3v6z"></path></svg>',
      'keywords'          => array( 'Animation', 'lottie', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Finitures List',
      'title'             => __('Finitures List', 'thor'),
      'description'       => __('Custom block that shows a list of Finitures', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M4 13.5h6v-3H4v3zm8 0h3v-3h-3v3zm5-3v3h3v-3h-3z"></path></svg>',
      'keywords'          => array( 'Finitures list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Tints List',
      'title'             => __('Tints List', 'thor'),
      'description'       => __('Custom block that shows a list of Tints', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M4 13.5h6v-3H4v3zm8 0h3v-3h-3v3zm5-3v3h3v-3h-3z"></path></svg>',
      'keywords'          => array( 'Tints list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Product List',
      'title'             => __('Product List', 'thor'),
      'description'       => __('Custom block that shows a list of Product', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="48" height="48" aria-hidden="true" focusable="false"><path d="M17 10h-1.2V7c0-2.1-1.7-3.8-3.8-3.8-2.1 0-3.8 1.7-3.8 3.8v3H7c-.6 0-1 .4-1 1v8c0 .6.4 1 1 1h10c.6 0 1-.4 1-1v-8c0-.6-.4-1-1-1zm-2.8 0H9.8V7c0-1.2 1-2.2 2.2-2.2s2.2 1 2.2 2.2v3z"></path></svg>',
      'keywords'          => array( 'Product list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Properties List',
      'title'             => __('Properties List', 'thor'),
      'description'       => __('Custom block that shows a list of Properties', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M4 13.5h6v-3H4v3zm8 0h3v-3h-3v3zm5-3v3h3v-3h-3z"></path></svg>',
      'keywords'          => array( 'Properties list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Investor List',
      'title'             => __('Investor List', 'thor'),
      'description'       => __('Custom block that shows a list of Investor', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M11.1 15.8H20v-1.5h-8.9v1.5zm0-8.6v1.5H20V7.2h-8.9zM5 6.7V10h1V5.3L3.8 6l.4 1 .8-.3zm-.4 5.7c-.3.1-.5.2-.7.3l.1 1.1c.2-.2.5-.4.8-.5.3-.1.6 0 .7.1.2.3 0 .8-.2 1.1-.5.8-.9 1.6-1.4 2.5h2.7v-1h-1c.3-.6.8-1.4.9-2.1.1-.3 0-.8-.2-1.1-.5-.6-1.3-.5-1.7-.4z"></path></svg>',
      'keywords'          => array( 'Investor list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Pie Chart',
      'title'             => __('Pie Chart', 'thor'),
      'description'       => __('Custom block that shows a list of Investor', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="48" height="48" aria-hidden="true" focusable="false"><path d="M12 4c-4.4 0-8 3.6-8 8v.1c0 4.1 3.2 7.5 7.2 7.9h.8c4.4 0 8-3.6 8-8s-3.6-8-8-8zm0 15V5c3.9 0 7 3.1 7 7s-3.1 7-7 7z"></path></svg>',
      'keywords'          => array( 'Pie Chart', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Person',
      'title'             => __('Person', 'thor'),
      'description'       => __('Custom block that shows a list of Investor', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path fill-rule="evenodd" d="M7.25 16.437a6.5 6.5 0 1 1 9.5 0V16A2.75 2.75 0 0 0 14 13.25h-4A2.75 2.75 0 0 0 7.25 16v.437Zm1.5 1.193a6.47 6.47 0 0 0 3.25.87 6.47 6.47 0 0 0 3.25-.87V16c0-.69-.56-1.25-1.25-1.25h-4c-.69 0-1.25.56-1.25 1.25v1.63ZM4 12a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm10-2a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Person', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Timeline',
      'title'             => __('Timeline', 'thor'),
      'description'       => __('Custom block that shows a timeline', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M5 13.5h3v-3H5v3zm5 0h3v-3h-3v3zM17 9l-1 1 2 2-2 2 1 1 3-3-3-3z"></path></svg>',
      'keywords'          => array( 'Timeline', 'year', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Card',
      'title'             => __('Card', 'thor'),
      'description'       => __('Custom block that shows a card', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M19 3H5c-.6 0-1 .4-1 1v7c0 .5.4 1 1 1h14c.5 0 1-.4 1-1V4c0-.6-.4-1-1-1zM5.5 10.5v-.4l1.8-1.3 1.3.8c.3.2.7.2.9-.1L11 8.1l2.4 2.4H5.5zm13 0h-2.9l-4-4c-.3-.3-.8-.3-1.1 0L8.9 8l-1.2-.8c-.3-.2-.6-.2-.9 0l-1.3 1V4.5h13v6zM4 20h9v-1.5H4V20zm0-4h16v-1.5H4V16z"></path></svg>',
      'keywords'          => array( 'Card', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Accordion wrapper',
      'title'             => __('Accordion Wrapper', 'thor'),
      'description'       => __('Insert the Accordion wrapper inside this block', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('posts', 'image', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),

        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Accordion Inner',
      'title'             => __('Accordion Inner', 'thor'),
      'description'       => __('Use this block inside an Accordion Wrapper', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M19 3H5c-.6 0-1 .4-1 1v7c0 .5.4 1 1 1h14c.5 0 1-.4 1-1V4c0-.6-.4-1-1-1zM5.5 10.5v-.4l1.8-1.3 1.3.8c.3.2.7.2.9-.1L11 8.1l2.4 2.4H5.5zm13 0h-2.9l-4-4c-.3-.3-.8-.3-1.1 0L8.9 8l-1.2-.8c-.3-.2-.6-.2-.9 0l-1.3 1V4.5h13v6zM4 20h9v-1.5H4V20zm0-4h16v-1.5H4V16z"></path></svg>',
      'keywords'          => array('posts', 'image', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),

        'mode' => false,
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Gallery',
      'title'             => __('Gallery slider', 'thor'),
      'description'       => __('Custom block that shows a list of Gallery', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="48" height="48" aria-hidden="true" focusable="false"><path d="M20.2 8v11c0 .7-.6 1.2-1.2 1.2H6v1.5h13c1.5 0 2.7-1.2 2.7-2.8V8h-1.5zM18 16.4V4.6c0-.9-.7-1.6-1.6-1.6H4.6C3.7 3 3 3.7 3 4.6v11.8c0 .9.7 1.6 1.6 1.6h11.8c.9 0 1.6-.7 1.6-1.6zM4.5 4.6c0-.1.1-.1.1-.1h11.8c.1 0 .1.1.1.1V12l-2.3-1.7c-.3-.2-.6-.2-.9 0l-2.9 2.1L8 11.3c-.2-.1-.5-.1-.7 0l-2.9 1.5V4.6zm0 11.8v-1.8l3.2-1.7 2.4 1.2c.2.1.5.1.8-.1l2.8-2 2.8 2v2.5c0 .1-.1.1-.1.1H4.6c0-.1-.1-.2-.1-.2z"></path></svg>',
      'keywords'          => array( 'Gallery list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Animated values',
      'title'             => __('Value animation', 'thor'),
      'description'       => __('Animate a value', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="48" height="48" aria-hidden="true" focusable="false"><path d="M18.1823 11.6392C18.1823 13.0804 17.0139 14.2487 15.5727 14.2487C14.3579 14.2487 13.335 13.4179 13.0453 12.2922L13.0377 12.2625L13.0278 12.2335L12.3985 10.377L12.3942 10.3785C11.8571 8.64997 10.246 7.39405 8.33961 7.39405C5.99509 7.39405 4.09448 9.29465 4.09448 11.6392C4.09448 13.9837 5.99509 15.8843 8.33961 15.8843C8.88499 15.8843 9.40822 15.781 9.88943 15.5923L9.29212 14.0697C8.99812 14.185 8.67729 14.2487 8.33961 14.2487C6.89838 14.2487 5.73003 13.0804 5.73003 11.6392C5.73003 10.1979 6.89838 9.02959 8.33961 9.02959C9.55444 9.02959 10.5773 9.86046 10.867 10.9862L10.8772 10.9836L11.4695 12.7311C11.9515 14.546 13.6048 15.8843 15.5727 15.8843C17.9172 15.8843 19.8178 13.9837 19.8178 11.6392C19.8178 9.29465 17.9172 7.39404 15.5727 7.39404C15.0287 7.39404 14.5066 7.4968 14.0264 7.6847L14.6223 9.20781C14.9158 9.093 15.2358 9.02959 15.5727 9.02959C17.0139 9.02959 18.1823 10.1979 18.1823 11.6392Z"></path></svg>',
      'keywords'          => array( 'Animated numbers', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Posts List',
      'title'             => __('Posts List', 'thor'),
      'description'       => __('Custom block that shows a list of Posts', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="48" height="48" aria-hidden="true" focusable="false"><path d="M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm.5 14c0 .3-.2.5-.5.5H6c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h12c.3 0 .5.2.5.5v12zM7 11h2V9H7v2zm0 4h2v-2H7v2zm3-4h7V9h-7v2zm0 4h7v-2h-7v2z"></path></svg>',
      'keywords'          => array( 'Posts List list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Dettaglio Decori',
      'title'             => __('Dettaglio Decori', 'thor'),
      'description'       => __('Custom block that shows a details of decors', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="48" height="48" aria-hidden="true" focusable="false"><path d="M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm.5 14c0 .3-.2.5-.5.5H6c-.3 0-.5-.2-.5-.5V6c0-.3.2-.5.5-.5h12c.3 0 .5.2.5.5v12zM7 11h2V9H7v2zm0 4h2v-2H7v2zm3-4h7V9h-7v2zm0 4h7v-2h-7v2z"></path></svg>',
      'keywords'          => array('Decors', 'decori', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));


  }, 10);
}