<div class="column subcategory desktop">
    @if($decors_category)
        @foreach ($decors_category as $position => $single_category)
            @php
                $term = $single_category['select_category'];
                $children = get_terms([
                    'taxonomy' => 'decors-category',
                    'parent' => $term->term_id,
                ]);
            @endphp
                <div class="links" data-category="{!! $term->term_id !!}">
                    @if($children && !is_wp_error($children))
                        <div class="mb-8">
                            @foreach ($children as $child)
                                <a href="{{ get_term_link($child, 'decors-category') }}" data-category="{{ $child->term_id }}"
                                    class="link">
                                    {!! $child->name !!}
                                </a>
                            @endforeach
                        </div>

                        @php
                            $term_link = get_term_link($term);
                        @endphp

                        @if (!is_wp_error($term_link))
                            <a href="{{ $term_link }}" class="link see-all">
                                <span>{!! __('See all - ', 'thor') . $term->name !!}</span>
                                @svg('images/arrow-right.svg')
                            </a>
                        @endif
                    @endif
                </div>
        @endforeach
    @endif
</div>

@if($decors_category)
    @foreach($decors_category as $position => $single_category)
        @php
            $term = $single_category['select_category'];
            $children = get_terms([
                'taxonomy' => 'decors-category',
                'parent' => $term->term_id
            ]);
        @endphp
        @if($children && !is_wp_error($children))
            <div class="column subcategory mobile" data-category="{!! $term->term_id !!}">
                <button class="close button arrow">
                    @svg('images/arrow-left.svg')
                    <span>{!! __('Back', 'thor') !!}</span>
                </button>
                <div class="inner">
                    <div class="links">
                        <a class="link active">
                            {!! $term->name !!}
                        </a>
                    </div>
                    <div class="links">
                        @foreach ($children as $child)
                            <a
                                href="{!! get_term_link($child, 'decors-category') !!}" data-category
                                class="link">
                                {!! $child->name !!}
                                Ciao
                            </a>
                        @endforeach
                    </div>
                    @php
                        $term_link = get_term_link($term);
                    @endphp
                    @if (!is_wp_error($term_link))
                        <a href="{{ $term_link }}" class="link see-all">
                            <span>{!! __('See all - ') . $term->name !!}</span>
                            @svg('images/arrow-right.svg')
                        </a>
                    @endif
                </div>
            </div>
        @endif
    @endforeach
@endif