
@if ($panel === 'decor')
    @php
        $decors_category = get_field('decors_category', 'option');
    @endphp
    <div class="column category">
        <h6>{!! __('Categories', 'thor') !!}</h6>
        <div class="links">
            @if($decors_category)
                @foreach ($decors_category as $position => $single_category)
                    @php
                        $type = $single_category['decor_category_type'];
                    @endphp
                    @if($type == 'category')
                        @php
                            $term = $single_category['select_category'];
                            $children = get_term_children($term->term_id, 'decors-category');

                            // $children = get_term([
                            //     'taxonomy' => 'decors-category',
                            //     'parent' => $term->term_id,
                            // ]);
                            $exclude_children_in_menu = get_field('exclude_children_in_menu', $term);
                        @endphp
                        @if($term)
                            <a
                                href="{!! get_term_link($term, 'decors-category') !!}"
                                @if(!$exclude_children_in_menu && $children) 
                                    data-category="{!! $term->term_id !!}" 
                                @else
                                    data-category
                                @endif
                                class="link">
                                    {!! $term->name !!}
                            </a>
                        @endif
                    @else
                        @php
                            $link = $single_category['link_category'];
                            $link_title = !empty($link['title']) ? $link['title'] : '';
                            $link_url = !empty($link['url']) ? $link['url'] : '';
                            $link_target = !empty($link['target']) ? $link['target'] : '';
                        @endphp
                        @if($link)
                            <a
                                href="{!! $link_url !!}" data-category
                                target="{!! $link_target !!}"
                                class="link"
                            >
                                {!! $link_title !!}
                            </a>
                        @endif
                    @endif
                @endforeach
            @endif
        </div>
    </div>
    @include('partials.panel.panel-decor-child', ['decors-category' => $decors_category])
    @include('partials.panel.panel-decor-image', ['decors-category' => $decors_category])
@endif