@if($data)
    @foreach ($data as $column => $values)
        @php
            $title = $values['title'];
            $links = $values['links'];
            $see_all = $values['see_all'];
            $categories = $values['categories'];
        @endphp
        @if ($title or $links or $see_all)
            <div class="column">
                <h6>{!! $title !!}</h6>
                <div class="links">
                    @if($links)
                    @foreach ($links as $position => $link)
                        @php
                            $link_title = !empty($link['link']['title']) ? $link['link']['title'] : '';
                            $link_url = !empty($link['link']['url']) ? $link['link']['url'] : '';
                            $link_target = !empty($link['link']['target']) ? $link['link']['target'] : '';
                        @endphp
                            <a href="{!! $link_url !!}" data-teaser={!! $column . '-' . $position !!}
                                target="{!! $link_target !!}" class="link">
                                {!! $link_title !!}
                            </a>
                        @endforeach
                    @endif
                </div>
                @if ($see_all)
                    <div>
                        <a href="{!! $see_all['url'] !!}" target="{!! $see_all['target'] !!}"
                            class="text-xs uppercase button arrow light">
                            {!! $see_all['title'] !!}
                            @svg('images/arrow-right.svg')
                        </a>
                    </div>
                @endif
            </div>
        @endif
    @endforeach
@endif