import {gsap} from 'gsap'

export default (() => {
    const investors = document.querySelectorAll('.accordions')
    let duration = 0.4

    investors.forEach((single) => {
        accordionListener(single, duration)
    })

    function accordionListener(single, duration) {
        const sections = single.querySelectorAll('.accordion-single')
        sections.forEach((section) => {
            const title = section.querySelector('.title')
            title.addEventListener('click', () => {
                animate(sections, section, title, duration)
            })
        })
    }

    function animate (sections, section, title, duration) {
        let content = section.querySelector('.content-accordion')
        closeOthers(sections, section, duration)

        let contentHeight = resetState(content)
        let openAccordion = openAnimation(content, title, contentHeight, duration)
        let closeAccordion = closeAnimation(content, title, contentHeight, duration)

        let prevWidth = window.innerWidth;
        adjustOnResize(prevWidth, content, contentHeight, section)

        playAnimation(section, openAccordion, closeAccordion)
    }

    function closeOthers(sections, section, content, duration) {
        sections.forEach(closeThis => {
            if (closeThis.classList.contains('opened') && !section.classList.contains('opened')) {
                closeThis.classList.remove('opened')

                let tClose = gsap.timeline()
                let contentClose = closeThis.querySelector('.content-accordion')
                let titleClose = closeThis.querySelector('.title')
                contentClose.classList.add('reposition')

                tClose.to(contentClose, {
                    opacity: 0,
                    duration: duration / 2,
                    onStart: () => {
                        titleClose.classList.add('not-active')
                    },
                })

                tClose.to(contentClose, {
                    height: 0,
                    pointerEvents: 'none',
                    onComplete: () => {
                        contentClose.classList.remove('reposition')
                        titleClose.classList.remove('not-active')
                    },
                })
            } else {
                let others = closeThis.querySelector('.content-accordion')
                let t4 = gsap.timeline()
                t4.to(others, {
                    duration: duration,
                    pointerEvents: 'all',
                })

                t4.to(others, {
                    pointerEvents: 'none',
                })
            }
        })
    }

    function resetState(content) {
        if (!content.classList.contains('reposition')) {
            gsap.to(content, {
                clearProps: 'height',
                duration: 0,
            })
        }

        content.classList.remove('reposition')
        let contentHeight = content.offsetHeight
        content.classList.add('reposition')

        return contentHeight
    }

    function openAnimation(content, title, contentHeight, duration) {
        let openAccordion = gsap.timeline();
    
        openAccordion.to(content, {
            height: () => contentHeight + 'px',
            duration: duration,
            onStart: () => {
                title.classList.add('not-active')
            },
        })
    
        openAccordion.to(content, {
            pointerEvents: 'all',
            opacity: 1,
            duration: duration / 2,
            onComplete: () => {
                title.classList.remove('not-active')
            },
        })
    
        openAccordion.pause()
    
        return openAccordion
    }
    
    function closeAnimation(content, title, contentHeight, duration) {
        let closeAccordion = gsap.timeline()
    
        closeAccordion.to(content, {
            opacity: 0,
            duration: duration / 2,
            onStart: () => {
                title.classList.add('not-active')
            },
        })
    
        closeAccordion.to(content, {
            height: 0,
            duration: duration,
            pointerEvents: 'none',
            onComplete: () => {
                closeAccordion.to(content, {
                    duration: 0,
                    clearProps: 'height',
                })
                content.classList.remove('reposition')
                title.classList.remove('not-active')
            },
        })
        
        closeAccordion.pause()
    
        return closeAccordion
    }
    
    function adjustOnResize (prevWidth, content, contentHeight, section) {
        const observer = new ResizeObserver(entries => {
            entries.forEach(() => {
                const width = window.innerWidth;
                if (typeof width === 'number' && width !== prevWidth) {
                    prevWidth = width
                    handleResize(content, contentHeight, section)
                }
            })
        });
    
        function handleResize(content, contentHeight, section) {
          content.classList.remove('reposition')
          gsap.to(content, {
            clearProps: 'height',
            duration: 0,
          })
    
          contentHeight = content.offsetHeight
          content.classList.add('reposition')
    
          if (section.classList.contains('opened')) {
            gsap.to(content, {
              height: contentHeight + 'px',
              duration: 0,
            })
          } else {
            content.classList.remove('reposition')
          }
        }
    
        observer.observe(document.querySelector('html'))
    }

    function playAnimation(section, openAccordion, closeAccordion) {
        if (!section.classList.contains('opened')) {
            section.classList.add('opened')
            openAccordion.play()
        } else {
            section.classList.remove('opened')
            closeAccordion.play()
        }
    }
})()

