import zoom from 'jquery-zoom'
import * as Helpers from './decor-helpers'

export default (() => {
    const decorSingle = $('.decor-single');

    decorSingle.each((index, single) => {
        const icons = $(single).find('.icons .icon, .zoom-decor .icon');
        const dataDecor = $(single).find('[data-decor]');
        const development = $(single).find('.zoom-development .development');

        icons.on('click', handleClick);
        $(window).on('load', handleWindowLoad);

        function handleClick() {
            const dataIcon = $(this).data('decor');
            changeDecor(dataIcon);
        }

        function handleWindowLoad() {
            $(development).zoom({
                magnify: 1.5,
                callback: handleZoomCallback,
            });
        }

        function handleZoomCallback() {
            development.each((index, single) => {
                const developmentImg = $(single).find('img');
                if (developmentImg.length > 0) {
                    Helpers.calculateAspectRatio(developmentImg, single);
                    $(window).on('resize', () => {
                        Helpers.calculateAspectRatio(developmentImg, single);
                    });
                }
            });
        }

        function changeDecor(dataIcon) {
            icons.removeClass('active');
            icons.filter(`[data-decor="${dataIcon}"]`).addClass('active');

            dataDecor.removeClass('active');
            dataDecor.filter(`[data-decor="${dataIcon}"]`).addClass('active');

            development.each((index, single) => {
                const developmentImg = $(single).find('img');
                if (developmentImg.length > 0) {
                    Helpers.calculateAspectRatio(developmentImg, single);
                }
            });
        }
    });
})()
