import {gsap, Power1} from 'gsap'

export default (() => {
    window.addEventListener('load', () => {
        const elements = document.querySelectorAll('.has-fade-bt-animation')

         elements && elements.forEach((el) => {
            const timelineBt = gsap.timeline({
                scrollTrigger: {
                    trigger: el,
                    start: 'top bottom-=5%',
                    toggleActions: 'play none none reverse',
                    end: 'center center',
                },
            })

            timelineBt.fromTo(el,{
                opacity: 0,
                y: 60,
            },{
                opacity: 1,
                ease: Power1.easeOut,
                y: 0,
            })
        })
    })
})()