@php
    $additional_field_name = get_field('additional_field_name') ? : '';
    $additional_field_decor = get_field('additional_field_decor');
    $name_a = get_field('name_a') ? : '';
    $name_b = get_field('name_b') ? : '';
    $name_c = get_field('name_c') ? : '';

    $filters = [
        $name_a =>  [
            'f1',
            'f2'
        ],

        $name_b =>  [
            'k1',
            'k2'
        ],

        $name_c =>  [
            't1',
            't2'
        ],

        $additional_field_name => [
            'additional_field_decor'
        ]

    ];
@endphp


<div class="focus">
    <h2>
        {!! __('Focus on', 'thor') !!}
    </h2>
    @foreach($filters as $key => $filter)
        <div class="container">
            @if($key)
                <h3>
                    {!! $key !!}
                </h3>
            @endif

            @php
                $posts = App::get_decors_filter_by_name($filter);
            @endphp

            <div class="inner">
                @foreach($posts as $key => $post)
                    @if($post[0])
                    @php
                        $tint_code = get_field('tint_code_' . $key);
                        $decor_code = get_post_meta($post[0]->ID, '_codice', true);
                        $get_tint = App::get_tint_by_code($tint_code, $post[0]->ID);
                    @endphp
                        <article {{post_class('teaser teaser-decor')}}>
                            <a href="{!! get_permalink($post[0]) !!}"
                                class="single">
                                <figure>
                                    @if(!$get_tint)
                                        <img
                                            class="lazy"
                                            src="{!! get_the_post_thumbnail_url($post[0]->ID, 'medium') !!}"
                                            data-src="{!! get_the_post_thumbnail_url($post[0]->ID, 'large') !!}"
                                        />
                                    @else
                                        <img
                                            src="{!! wp_get_attachment_url($get_tint['_immagine_di_anteprima_media_id']) !!}"
                                        />
                                    @endif
                                </figure>
                                <header>
                                    <p>{{ $post[0]->post_title }}</p>
                                </header>
                            </a>
                        </article>
                    @endif
                @endforeach
            </div>
        </div>
    @endforeach
</div>