@php
    $block_info = App::get_block_info($block);

    $title = get_field('title');
    $subtitle = get_field('subtitle');
    $have_modal = get_field('have_modal');
    $links = get_field('links');
    $description = get_field('description');
@endphp
<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} person">
     <div
      @if($have_modal)
        data-title="{!! $title !!}"
        data-subtitle="{!! $subtitle !!}"
        data-description="{{ $description }}"
        data-links="{{ json_encode($links) }}"
        class="data has-modal"
      @endif
      >
         <div class="title outside">
             <h3>{!! $title !!}</h3>
             @if($have_modal)
                <div>
                    @svg('images/arrow-right.svg')
                </div>
             @endif
         </div>
         <p class="subtitle">{!! $subtitle !!}</p>
     </div>


</div>