@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');

  $args = array(
      'post_type' => 'product',
      'numberposts' => $how_much,
  );

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

     case 'taxonomy':
            $taxonomy = get_field('taxonomy');
            $args['tax_query'][] = 
                [
                    'taxonomy' => 'product-collection',
                    'terms' => $taxonomy,
                ];

            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break;

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} posts-list">

    <div class="grid-list four">
        @php
            global $post;
        @endphp
        @foreach($posts as $key => $post)
            <div>
                @include('partials.teaser-' . get_post_type($post))
            </div>
        @endforeach
    </div>
</div>
