import Swiper, { Autoplay } from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar, Autoplay]);
export default (() => {
    const singleProduct = document.querySelector('.single-product')

    if(singleProduct) {
        const sheetsOverlay = singleProduct.querySelectorAll('.single-sheet.with-overlay')
        
        sheetsOverlay.forEach(overlay => {
            const teaserSheet = overlay.querySelectorAll('[data-key]')
            const sliders = overlay.querySelector('.swiper-container')
            const currentOverlay = overlay.querySelector('.sheet-overlay')

            teaserSheet.forEach(teaser => {
                teaser && teaser.addEventListener('click', () => {
                    const slidePosition = teaser.dataset.key
                    currentOverlay.classList.add('active')
                    if(sheetList) {
                        sheetList.slideTo(slidePosition, 0)
                    }
                })
            })

            const sheetsClose = overlay.querySelector('[data-close]')
            sheetsClose && sheetsClose.addEventListener('click', () => {
                currentOverlay.classList.remove('active')
            })

            const sheetList = sliders && new Swiper(sliders, {
                freeMode: true,
                freeModeSticky: true,
                spaceBetween: 16,
                slidesPerView: 1,
                scrollbar: {
                    draggable: false,
                },
                navigation: {
                    nextEl: sliders.querySelector('.swiper-button-next'),
                    prevEl: sliders.querySelector('.swiper-button-prev'),
                },
            });
        })
    }
})()