
@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = term_description(get_queried_object()) ? : '';
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])
    @include('partials.filter-buttons', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'only_queried_children' => true])

    <div class="flex flex-col list">
      @if (!have_posts())
      @else
        <div class="inner-list">
          <div class="decors-container" data-load-more data-default="grid-small">
            @php
              global $post;
            @endphp
            @while (have_posts()) @php the_post() @endphp
                <div class="w-full">
                  @include('partials.teaser-'.get_post_type(), ['show_highlight_label' => true])
                </div>
            @endwhile
          </div><!--row-->
        </div>
      @endif
      @include('partials.decor.decor-single-panel', ['taxonomy' => 'decors-category', 'post_type' => 'decor'])
      @include('partials.decor.decor-single-filter', ['taxonomy' => 'decors-category', 'post_type' => 'decor'])
    </div>
    
    @php
      $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    @endphp
    @include('partials.utils.infinite-loader')

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
