<?php

namespace App;

// array_map(function ($file) {
//   $file = "../app/gutenberg/{$file}.php";
//   if (!locate_template($file, true, true)) {
//     wp_die(sprintf(__('Error locating <code>%s</code> for inclusion.', 'thor'), $file), 'File not found');
//   }
// }, [
//   'blocks',
//   'patterns',
// ]);

add_action('enqueue_block_editor_assets', function () {
  wp_enqueue_script('thor-gutenberg', asset_path('scripts/gutenberg.js'), array('wp-blocks'), '1.0', true);
});

//custom styles
/**
 * Theme setup
 */
add_action('after_setup_theme', function () {
  // add_theme_support( 'dark-editor-style' );
  add_theme_support('editor-styles');
  add_theme_support('align-wide');
  add_theme_support('responsive-embeds');
  add_theme_support('wp-block-styles');
  add_theme_support('custom-line-height');
  add_theme_support('custom-spacing');
  add_theme_support('custom-units');

  add_editor_style(asset_path('styles/gutenberg.css'));

  // add_theme_support( 'disable-custom-colors' );

  add_theme_support('editor-color-palette', array(
    array(
      'name' => __('Dark', 'thor'),
      'slug' => 'primary-dark',
      'color' => '#282828',
    ),
    array(
      'name' => __('Gray', 'thor'),
      'slug' => 'primary',
      'color' => '#424242',
    ),
    array(
      'name' => __('Light', 'thor'),
      'slug' => 'primary-light',
      'color' => '#8e8e8e',
    ),
    array(
      'name' => __('Background', 'thor'),
      'slug' => 'primary-background',
      'color' => '#adadac',
    ),
    array(
      'name' => __('Off White', 'thor'),
      'slug' => 'primary-offwhite',
      'color' => '#f3f4f4',
    ),
    array(
      'name' => __('White', 'thor'),
      'slug' => 'white',
      'color' => '#ffffff',
    ),
  ));

  // Next line disallow custom font size
  // add_theme_support('disable-custom-font-sizes');

  // Next line replace text sizes preset
  add_theme_support('editor-font-sizes', array(
    array(
      'name' => __('XXXS 10/AUTO - 10/AUTO', 'thor'),
      'size' => 10.1,
      'slug' => 'xxxs'
    ),
    array(
      'name' => __('XXS - 11/13 - 11/13', 'thor'),
      'size' => 11.1,
      'slug' => 'xxs'
    ),
    array(
      'name' => __('XS - 12/14 - 12/14', 'thor'),
      'size' => 12.1,
      'slug' => 'xs'
    ),
    array(
      'name' => __('SM 14/19 - 14/19', 'thor'),
      'size' => 14.1,
      'slug' => 'sm'
    ),
    array(
      'name' => __('Base 16/22 - 13/18', 'thor'),
      'size' => 16.1,
      'slug' => 'base'
    ),
    array(
      'name' => __('LG 18/22 - 18/22', 'thor'),
      'size' => 18.1,
      'slug' => 'lg'
    ),
    array(
      'name' => __('XL 26/31 - 18/22', 'thor'),
      'size' => 26.2,
      'slug' => 'xl'
    ),
    array(
      'name' => __('ALT XL 26/31 - 18/22', 'thor'),
      'size' => 26.1,
      'slug' => 'alt-xl'
    ),
    array(
      'name' => __('2XL 40/50 - 26/31', 'thor'),
      'size' => 40.1,
      'slug' => '2xl'
    ),
    array(
      'name' => __('3XL 60/60 - 60/60', 'thor'),
      'size' => 60.1,
      'slug' => '3xl'
    ),
    array(
      'name' => __('4XL 200/200 - 80/80', 'thor'),
      'size' => 200.1,
      'slug' => '4xl'
    ),
  ));
});

/**
 * Block template for posts
 * @see https://www.billerickson.net/gutenberg-block-templates/
 *
 */
// add_action( 'init', function() {
//   //Creo un template per un post
//   $post_type_object = get_post_type_object( 'post' );
//   $post_type_object->template = array(
//     array( 'core/paragraph', array(
//       'placeholder' => 'Inserisci qui il sottotiolo',
//     ) ),
//     array( 'core/image', array(
//       'align' => 'wide',
//     ) ),
//     array( 'core/freeform', array(
//       'placeholder' => 'Inserisci il contenuto'
//     )),
//   );
//   $post_type_object->template_lock = 'all';
// });

//Create custom Gutenberg category
add_filter('block_categories', function ($categories, $post) {
  return array_merge(
    array(
      array(
        'slug' => 'thor-blocks',
        'title' => __('Custom Blocks', 'thor'),
      ),
    ),
    $categories
  );
}, 10, 2);


// add_filter( 'allowed_block_types', function ( $allowed_blocks, $post ) {
//   $allowed_blocks = array(
// 		'core/image',
// 		'core/paragraph',
// 		'core/heading',
// 		'core/list'
// 	);

//   return $allowed_blocks;
// }, 10, 2);
