export default (() => {
    const activatePopup = document.querySelector('[data-activate-popup]')

    if(activatePopup) {
        const getCookieValue = (name) => (
            document.cookie.match('(^|;)\\s*' + name + '\\s*=\\s*([^;]+)') &&
            document.cookie.match('(^|;)\\s*' + name + '\\s*=\\s*([^;]+)').pop() || ''
        )
    
        const popup = document.querySelector('[data-popup].popup')
        const autoclose = popup.dataset.autoclose
        const howLong = Number(popup.dataset.howlong)
    
        const closer = popup.querySelector('.popup-closer')
        const opener = document.querySelector('[data-popup].popup-opener')
    
        const cookieValue = getCookieValue('viewed_popup')
        console.log(cookieValue)

        if (cookieValue != 'false') {
          popup.classList.add('opened')
    
          if(autoclose == true) {
              setTimeout(() => {
                  popup.classList.remove('opened')
              }, howLong);
          }
        }
    
        opener.addEventListener('click', () => {
          popup.classList.add('opened')

            if (autoclose == true) {
                setTimeout(() => {
                    popup.classList.remove('opened')
                }, howLong);
            }
        })
    
        closer.addEventListener('click', () => {
          document.cookie = 'viewed_popup=false'
          popup.classList.remove('opened')
        })
    }
})()
