@php
    $description = get_field('description', $post);
    $link = get_field('link', $post);

    $terms = get_the_terms($post->ID, 'downloads-category');
@endphp

<article {{post_class('teaser-downloads '. $type)}}>
    @if($link)
        <a href="{!! $link['url'] !!}"
            target="{!! $link['target'] !!}">
    @else
        <a class="without-link">
    @endif

        @if($type == 'image')
                <figure>
                    <img
                        class="lazy"
                        src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
                        data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}"
                    />
                </figure>
        @endif
    
    <header>
        <div>
            @if($type == 'short' &&
                $terms)
                <div class="category">
                    @foreach($terms as $term)
                        @if($term->parent)
                            {!! $term->name !!}
                        @endif
                    @endforeach
                </div>
            @endif
            <h2>
                {!! get_the_title() !!}
            </h2>
            <div class="mt-2 description">
                {!! $description !!}
            </div>
            @if($type == 'image' || $type == 'short') 
                <div class="mt-1 size">
                    <span>
                        {{ __('Dimensione: ') }}
                    </span>
                    @if($link)
                        {!! App::human_filesize($link['filesize']) !!}
                    @else 
                        {!! __('0.0') !!}
                    @endif
                </div>
            @endif
        </div>
        @if($type != 'image')
            <a 
                href="{!! $link['url'] !!}"
                target="{!! $link['target'] !!}"
                class="download">

                <p>
                    {{ __('Download', 'thor') }}
                </p>

                @svg('images/arrow-down.svg')

            </a>
        @endif
    </header>

    </a>
</article>
