<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function human_filesize($bytes, $decimals = 1){
        $sz = 'BKMGTP';
        $factor = floor((strlen($bytes) - 1) / 3);
        return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'thor');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Search Results for %s', 'thor'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'thor');
        }
        return get_the_title();
    }

    public static function get_block_info($block) {
        $id = 'thor-' . $block['slug'] . '-' . $block['id'];

        if (!empty($block['anchor'])) {
            $id = $block['anchor'];
        }

        $className = 'thor-' . $block['slug'];
        if (!empty($block['className'])) {
            $className .= ' container ' . $block['className'];
        }

        if (!empty($block['align'])) {
            $className .= ' align' . $block['align'];
        }

        return array('id' => esc_attr($id), 'classes' => esc_attr($className));
    }

    public function credits()
    {
        return __('Designed and developed by <a href="https://dueper.net" target="_blank">Dueper Design</a>', 'thor');
    }
}
