<?php 

namespace App;

/**
 * Add Language selector in menu
 */
if(function_exists('icl_get_languages')) {
  add_filter( 'wp_nav_menu_items', function ($items, $args) {
    $languages = icl_get_languages('skip_missing=0&orderby=code');
    if($languages):
    $menu_location = 'primary_navigation';
      if($args->theme_location == $menu_location):
            $items .= '<li class="menu-item-language"><a href="#" class="dropdown-toggle">'._x("Languages", "menu", "thor").' <b class="caret"></b></a><ul class="dropdown-menu">';
            foreach($languages as $l) :
                if(!$l['active']) :
                    $items .= '<li><a href="'.$l['url'].'">'.$l['native_name'].'</a>';
                else :
                    $items .= '<li class="active"><a href="'.$l['url'].'">'.$l['native_name'].'</a>';
                endif;
            endforeach;
            $items .= '</ul></li>';
        endif;
    endif;

    return $items;
  },  10, 2);
}

/**
 * Add featured image in RSS
 */
add_filter('the_excerpt_rss', __NAMESPACE__ .'\\rss_post_thumbnail', 10, 2);
add_filter('the_content_feed', __NAMESPACE__ .'\\rss_post_thumbnail', 10, 2);
function rss_post_thumbnail($content) {
  global $post;
  if(has_post_thumbnail($post->ID)) :
    $content = '<p>' . get_the_post_thumbnail($post->ID) .
    '</p>' . get_the_content();
  endif;
  return $content;
}

/**
 * Revising Default Excerpt
 */
add_filter('excerpt_more', function ($more) {
  global $post;
  return '...';
}, 10, 2);


/**
 * Revising Default Excerpt
 */
add_filter( 'excerpt_length', function ($length) {
  return 20;
}, 10, 2 );


/**
 * Wrap oEmbed with container
 */
add_filter('embed_oembed_html', function ($html) {
  return "<div class='video-responsive'>{$html}</div>";
}, 10, 1);
